/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;
import java.util.ArrayList;

public class SelectionRecord
extends Record {
    public static final short sid = 29;
    private byte field_1_pane;
    private int field_2_row_active_cell;
    private short field_3_col_active_cell;
    private short field_4_ref_active_cell;
    private short field_5_num_refs;
    private ArrayList field_6_refs;

    public SelectionRecord() {
    }

    public SelectionRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 29) {
            throw new RecordFormatException("NOT A valid Selection RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_pane = recordInputStream.readByte();
        this.field_2_row_active_cell = recordInputStream.readUShort();
        this.field_3_col_active_cell = recordInputStream.readShort();
        this.field_4_ref_active_cell = recordInputStream.readShort();
        this.field_5_num_refs = recordInputStream.readShort();
        this.field_6_refs = new ArrayList(this.field_5_num_refs);
        for (int i = 0; i < this.field_5_num_refs; ++i) {
            this.field_6_refs.add(new Reference(recordInputStream));
        }
    }

    public void setPane(byte by) {
        this.field_1_pane = by;
    }

    public void setActiveCellRow(int n) {
        this.field_2_row_active_cell = n;
    }

    public void setActiveCellCol(short s) {
        this.field_3_col_active_cell = s;
    }

    public void setActiveCellRef(short s) {
        this.field_4_ref_active_cell = s;
    }

    public void setNumRefs(short s) {
        this.field_5_num_refs = s;
    }

    public byte getPane() {
        return this.field_1_pane;
    }

    public int getActiveCellRow() {
        return this.field_2_row_active_cell;
    }

    public short getActiveCellCol() {
        return this.field_3_col_active_cell;
    }

    public short getActiveCellRef() {
        return this.field_4_ref_active_cell;
    }

    public short getNumRefs() {
        return this.field_5_num_refs;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SELECTION]\n");
        stringBuffer.append("    .pane            = ").append(Integer.toHexString(this.getPane())).append("\n");
        stringBuffer.append("    .activecellrow   = ").append(Integer.toHexString(this.getActiveCellRow())).append("\n");
        stringBuffer.append("    .activecellcol   = ").append(Integer.toHexString(this.getActiveCellCol())).append("\n");
        stringBuffer.append("    .activecellref   = ").append(Integer.toHexString(this.getActiveCellRef())).append("\n");
        stringBuffer.append("    .numrefs         = ").append(Integer.toHexString(this.getNumRefs())).append("\n");
        stringBuffer.append("[/SELECTION]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)29);
        LittleEndian.putShort(byArray, 2 + n, (short)15);
        byArray[4 + n] = this.getPane();
        LittleEndian.putShort(byArray, 5 + n, (short)this.getActiveCellRow());
        LittleEndian.putShort(byArray, 7 + n, this.getActiveCellCol());
        LittleEndian.putShort(byArray, 9 + n, this.getActiveCellRef());
        LittleEndian.putShort(byArray, 11 + n, (short)1);
        LittleEndian.putShort(byArray, 13 + n, (short)this.getActiveCellRow());
        LittleEndian.putShort(byArray, 15 + n, (short)this.getActiveCellRow());
        byArray[17 + n] = (byte)this.getActiveCellCol();
        byArray[18 + n] = (byte)this.getActiveCellCol();
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 19;
    }

    public short getSid() {
        return 29;
    }

    public Object clone() {
        SelectionRecord selectionRecord = new SelectionRecord();
        selectionRecord.field_1_pane = this.field_1_pane;
        selectionRecord.field_2_row_active_cell = this.field_2_row_active_cell;
        selectionRecord.field_3_col_active_cell = this.field_3_col_active_cell;
        selectionRecord.field_4_ref_active_cell = this.field_4_ref_active_cell;
        selectionRecord.field_5_num_refs = this.field_5_num_refs;
        selectionRecord.field_6_refs = this.field_6_refs;
        return selectionRecord;
    }

    public class Reference {
        private short field_1_first_row;
        private short field_2_last_row;
        private byte field_3_first_column;
        private byte field_4_last_column;

        Reference(RecordInputStream recordInputStream) {
            this.field_1_first_row = recordInputStream.readShort();
            this.field_2_last_row = recordInputStream.readShort();
            this.field_3_first_column = recordInputStream.readByte();
            this.field_4_last_column = recordInputStream.readByte();
        }

        public short getFirstRow() {
            return this.field_1_first_row;
        }

        public short getLastRow() {
            return this.field_2_last_row;
        }

        public byte getFirstColumn() {
            return this.field_3_first_column;
        }

        public byte getLastColumn() {
            return this.field_4_last_column;
        }
    }
}

