/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.ExtSSTRecord;
import com.fr.third.org.apache.poi.hssf.record.SSTRecordHeader;
import com.fr.third.org.apache.poi.hssf.record.UnicodeString;
import com.fr.third.org.apache.poi.util.IntMapper;
import com.fr.third.org.apache.poi.util.LittleEndian;

class SSTSerializer {
    private IntMapper strings;
    private SSTRecordHeader sstRecordHeader;
    int[] bucketAbsoluteOffsets;
    int[] bucketRelativeOffsets;
    int startOfSST;
    int startOfRecord;

    public SSTSerializer(IntMapper intMapper, int n, int n2) {
        this.strings = intMapper;
        this.sstRecordHeader = new SSTRecordHeader(n, n2);
        int n3 = ExtSSTRecord.getNumberOfInfoRecsForStrings(intMapper.size());
        this.bucketAbsoluteOffsets = new int[n3];
        this.bucketRelativeOffsets = new int[n3];
    }

    public int serialize(int n, byte[] byArray) {
        short s;
        UnicodeString.UnicodeRecordStats unicodeRecordStats = new UnicodeString.UnicodeRecordStats();
        this.sstRecordHeader.writeSSTHeader(unicodeRecordStats, byArray, 0 + n, 0);
        int n2 = n + 12;
        for (s = 0; s < this.strings.size(); ++s) {
            int n3;
            if (s % 8 == 0 && (n3 = s / 8) < 128) {
                this.bucketAbsoluteOffsets[n3] = n2 - n;
                this.bucketRelativeOffsets[n3] = n2 - n;
            }
            UnicodeString unicodeString = this.getUnicodeString(s);
            n2 += unicodeString.serialize(unicodeRecordStats, n2, byArray);
        }
        if (unicodeRecordStats.lastLengthPos != -1) {
            s = (short)(n2 - unicodeRecordStats.lastLengthPos - 2);
            if (s > 8224) {
                throw new InternalError();
            }
            LittleEndian.putShort(byArray, unicodeRecordStats.lastLengthPos, s);
        }
        return n2 - n;
    }

    private UnicodeString getUnicodeString(int n) {
        return SSTSerializer.getUnicodeString(this.strings, n);
    }

    private static UnicodeString getUnicodeString(IntMapper intMapper, int n) {
        return (UnicodeString)intMapper.get(n);
    }

    public int[] getBucketAbsoluteOffsets() {
        return this.bucketAbsoluteOffsets;
    }

    public int[] getBucketRelativeOffsets() {
        return this.bucketRelativeOffsets;
    }
}

