/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.ExtSSTRecord;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.SSTDeserializer;
import com.fr.third.org.apache.poi.hssf.record.SSTRecordSizeCalculator;
import com.fr.third.org.apache.poi.hssf.record.SSTSerializer;
import com.fr.third.org.apache.poi.hssf.record.UnicodeString;
import com.fr.third.org.apache.poi.util.IntMapper;
import java.util.Iterator;

public class SSTRecord
extends Record {
    private static UnicodeString EMPTY_STRING = new UnicodeString("");
    static final int MAX_RECORD_SIZE = 8228;
    static final int STD_RECORD_OVERHEAD = 4;
    static final int SST_RECORD_OVERHEAD = 12;
    static final int MAX_DATA_SPACE = 8216;
    static final int STRING_MINIMAL_OVERHEAD = 3;
    public static final short sid = 252;
    private int field_1_num_strings;
    private int field_2_num_unique_strings;
    private IntMapper field_3_strings;
    private SSTDeserializer deserializer;
    int[] bucketAbsoluteOffsets;
    int[] bucketRelativeOffsets;

    public SSTRecord() {
        this.field_1_num_strings = 0;
        this.field_2_num_unique_strings = 0;
        this.field_3_strings = new IntMapper();
        this.deserializer = new SSTDeserializer(this.field_3_strings);
    }

    public SSTRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    public int addString(UnicodeString unicodeString) {
        int n;
        ++this.field_1_num_strings;
        UnicodeString unicodeString2 = unicodeString == null ? EMPTY_STRING : unicodeString;
        int n2 = this.field_3_strings.getIndex(unicodeString2);
        if (n2 != -1) {
            n = n2;
        } else {
            n = this.field_3_strings.size();
            ++this.field_2_num_unique_strings;
            SSTDeserializer.addToStringTable(this.field_3_strings, unicodeString2);
        }
        return n;
    }

    public int getNumStrings() {
        return this.field_1_num_strings;
    }

    public int getNumUniqueStrings() {
        return this.field_2_num_unique_strings;
    }

    public void setNumStrings(int n) {
        this.field_1_num_strings = n;
    }

    public void setNumUniqueStrings(int n) {
        this.field_2_num_unique_strings = n;
    }

    public UnicodeString getString(int n) {
        return (UnicodeString)this.field_3_strings.get(n);
    }

    public boolean isString16bit(int n) {
        UnicodeString unicodeString = (UnicodeString)this.field_3_strings.get(n);
        return (unicodeString.getOptionFlags() & 1) == 1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SST]\n");
        stringBuffer.append("    .numstrings     = ").append(Integer.toHexString(this.getNumStrings())).append("\n");
        stringBuffer.append("    .uniquestrings  = ").append(Integer.toHexString(this.getNumUniqueStrings())).append("\n");
        for (int i = 0; i < this.field_3_strings.size(); ++i) {
            UnicodeString unicodeString = (UnicodeString)this.field_3_strings.get(i);
            stringBuffer.append("    .string_" + i + "      = ").append(unicodeString.getDebugInfo()).append("\n");
        }
        stringBuffer.append("[/SST]\n");
        return stringBuffer.toString();
    }

    public short getSid() {
        return 252;
    }

    public int hashCode() {
        return this.field_2_num_unique_strings;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        SSTRecord sSTRecord = (SSTRecord)object;
        return this.field_1_num_strings == sSTRecord.field_1_num_strings && this.field_2_num_unique_strings == sSTRecord.field_2_num_unique_strings && this.field_3_strings.equals(sSTRecord.field_3_strings);
    }

    protected void validateSid(short s) throws RecordFormatException {
        if (s != 252) {
            throw new RecordFormatException("NOT An SST RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_num_strings = recordInputStream.readInt();
        this.field_2_num_unique_strings = recordInputStream.readInt();
        this.field_3_strings = new IntMapper();
        this.deserializer = new SSTDeserializer(this.field_3_strings);
        this.deserializer.manufactureStrings(this.field_2_num_unique_strings, recordInputStream);
    }

    Iterator getStrings() {
        return this.field_3_strings.iterator();
    }

    int countStrings() {
        return this.field_3_strings.size();
    }

    public int serialize(int n, byte[] byArray) {
        SSTSerializer sSTSerializer = new SSTSerializer(this.field_3_strings, this.getNumStrings(), this.getNumUniqueStrings());
        int n2 = sSTSerializer.serialize(n, byArray);
        this.bucketAbsoluteOffsets = sSTSerializer.getBucketAbsoluteOffsets();
        this.bucketRelativeOffsets = sSTSerializer.getBucketRelativeOffsets();
        return n2;
    }

    public int getRecordSize() {
        SSTRecordSizeCalculator sSTRecordSizeCalculator = new SSTRecordSizeCalculator(this.field_3_strings);
        int n = sSTRecordSizeCalculator.getRecordSize();
        return n;
    }

    SSTDeserializer getDeserializer() {
        return this.deserializer;
    }

    public ExtSSTRecord createExtSSTRecord(int n) {
        if (this.bucketAbsoluteOffsets == null || this.bucketAbsoluteOffsets == null) {
            throw new IllegalStateException("SST record has not yet been serialized.");
        }
        ExtSSTRecord extSSTRecord = new ExtSSTRecord();
        extSSTRecord.setNumStringsPerBucket((short)8);
        int[] nArray = (int[])this.bucketAbsoluteOffsets.clone();
        int[] nArray2 = (int[])this.bucketRelativeOffsets.clone();
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = n2++;
            nArray[n3] = nArray[n3] + n;
        }
        extSSTRecord.setBucketOffsets(nArray, nArray2);
        return extSSTRecord;
    }

    public int calcExtSSTRecordSize() {
        return ExtSSTRecord.getRecordSizeForStrings(this.field_3_strings.size());
    }
}

