/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class SCLRecord
extends Record {
    public static final short sid = 160;
    private short field_1_numerator;
    private short field_2_denominator;

    public SCLRecord() {
    }

    public SCLRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 160) {
            throw new RecordFormatException("Not a SCL record");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_numerator = recordInputStream.readShort();
        this.field_2_denominator = recordInputStream.readShort();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SCL]\n");
        stringBuffer.append("    .numerator            = ").append("0x").append(HexDump.toHex(this.getNumerator())).append(" (").append(this.getNumerator()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .denominator          = ").append("0x").append(HexDump.toHex(this.getDenominator())).append(" (").append(this.getDenominator()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("[/SCL]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = 0;
        LittleEndian.putShort(byArray, 0 + n, (short)160);
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(byArray, 4 + n + n2, this.field_1_numerator);
        LittleEndian.putShort(byArray, 6 + n + n2, this.field_2_denominator);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 8;
    }

    public short getSid() {
        return 160;
    }

    public Object clone() {
        SCLRecord sCLRecord = new SCLRecord();
        sCLRecord.field_1_numerator = this.field_1_numerator;
        sCLRecord.field_2_denominator = this.field_2_denominator;
        return sCLRecord;
    }

    public short getNumerator() {
        return this.field_1_numerator;
    }

    public void setNumerator(short s) {
        this.field_1_numerator = s;
    }

    public short getDenominator() {
        return this.field_2_denominator;
    }

    public void setDenominator(short s) {
        this.field_2_denominator = s;
    }
}

