/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.LittleEndian;

public final class RowRecord
extends Record
implements Comparable {
    public static final short sid = 520;
    private static final int OPTION_BITS_ALWAYS_SET = 256;
    private static final int DEFAULT_HEIGHT_BIT = 32768;
    public static final int MAX_ROW_NUMBER = 65535;
    private int field_1_row_number;
    private short field_2_first_col;
    private short field_3_last_col;
    private short field_4_height;
    private short field_5_optimize;
    private short field_6_reserved;
    private int field_7_option_flags;
    private static final BitField outlineLevel = BitFieldFactory.getInstance(7);
    private static final BitField colapsed = BitFieldFactory.getInstance(16);
    private static final BitField zeroHeight = BitFieldFactory.getInstance(32);
    private static final BitField badFontHeight = BitFieldFactory.getInstance(64);
    private static final BitField formatted = BitFieldFactory.getInstance(128);
    private short field_8_xf_index;

    public RowRecord(int n) {
        this.field_1_row_number = n;
        this.field_2_first_col = (short)-1;
        this.field_3_last_col = (short)-1;
        this.field_4_height = Short.MIN_VALUE;
        this.field_4_height = Short.MIN_VALUE;
        this.field_5_optimize = 0;
        this.field_6_reserved = 0;
        this.field_7_option_flags = 256;
        this.field_8_xf_index = (short)15;
    }

    public RowRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 520) {
            throw new RecordFormatException("NOT A valid ROW RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_row_number = recordInputStream.readUShort();
        this.field_2_first_col = recordInputStream.readShort();
        this.field_3_last_col = recordInputStream.readShort();
        this.field_4_height = recordInputStream.readShort();
        this.field_5_optimize = recordInputStream.readShort();
        this.field_6_reserved = recordInputStream.readShort();
        this.field_7_option_flags = recordInputStream.readShort();
        this.field_8_xf_index = recordInputStream.readShort();
    }

    public void setRowNumber(int n) {
        this.field_1_row_number = n;
    }

    public void setFirstCol(short s) {
        this.field_2_first_col = s;
    }

    public void setLastCol(short s) {
        this.field_3_last_col = s;
    }

    public void setHeight(short s) {
        this.field_4_height = s;
    }

    public void setOptimize(short s) {
        this.field_5_optimize = s;
    }

    public void setOptionFlags(short s) {
        this.field_7_option_flags = s | 0x100;
    }

    public void setOutlineLevel(short s) {
        this.field_7_option_flags = outlineLevel.setValue(this.field_7_option_flags, s);
    }

    public void setColapsed(boolean bl) {
        this.field_7_option_flags = colapsed.setBoolean(this.field_7_option_flags, bl);
    }

    public void setZeroHeight(boolean bl) {
        this.field_7_option_flags = zeroHeight.setBoolean(this.field_7_option_flags, bl);
    }

    public void setBadFontHeight(boolean bl) {
        this.field_7_option_flags = badFontHeight.setBoolean(this.field_7_option_flags, bl);
    }

    public void setFormatted(boolean bl) {
        this.field_7_option_flags = formatted.setBoolean(this.field_7_option_flags, bl);
    }

    public void setXFIndex(short s) {
        this.field_8_xf_index = s;
    }

    public int getRowNumber() {
        return this.field_1_row_number;
    }

    public short getFirstCol() {
        return this.field_2_first_col;
    }

    public short getLastCol() {
        return this.field_3_last_col;
    }

    public short getHeight() {
        return this.field_4_height;
    }

    public short getOptimize() {
        return this.field_5_optimize;
    }

    public short getOptionFlags() {
        return (short)this.field_7_option_flags;
    }

    public short getOutlineLevel() {
        return (short)outlineLevel.getValue(this.field_7_option_flags);
    }

    public boolean getColapsed() {
        return colapsed.isSet(this.field_7_option_flags);
    }

    public boolean getZeroHeight() {
        return zeroHeight.isSet(this.field_7_option_flags);
    }

    public boolean getBadFontHeight() {
        return badFontHeight.isSet(this.field_7_option_flags);
    }

    public boolean getFormatted() {
        return formatted.isSet(this.field_7_option_flags);
    }

    public short getXFIndex() {
        return this.field_8_xf_index;
    }

    public boolean isInValueSection() {
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ROW]\n");
        stringBuffer.append("    .rownumber      = ").append(Integer.toHexString(this.getRowNumber())).append("\n");
        stringBuffer.append("    .firstcol       = ").append(Integer.toHexString(this.getFirstCol())).append("\n");
        stringBuffer.append("    .lastcol        = ").append(Integer.toHexString(this.getLastCol())).append("\n");
        stringBuffer.append("    .height         = ").append(Integer.toHexString(this.getHeight())).append("\n");
        stringBuffer.append("    .optimize       = ").append(Integer.toHexString(this.getOptimize())).append("\n");
        stringBuffer.append("    .reserved       = ").append(Integer.toHexString(this.field_6_reserved)).append("\n");
        stringBuffer.append("    .optionflags    = ").append(Integer.toHexString(this.getOptionFlags())).append("\n");
        stringBuffer.append("        .outlinelvl = ").append(Integer.toHexString(this.getOutlineLevel())).append("\n");
        stringBuffer.append("        .colapsed   = ").append(this.getColapsed()).append("\n");
        stringBuffer.append("        .zeroheight = ").append(this.getZeroHeight()).append("\n");
        stringBuffer.append("        .badfontheig= ").append(this.getBadFontHeight()).append("\n");
        stringBuffer.append("        .formatted  = ").append(this.getFormatted()).append("\n");
        stringBuffer.append("    .xfindex        = ").append(Integer.toHexString(this.getXFIndex())).append("\n");
        stringBuffer.append("[/ROW]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)520);
        LittleEndian.putShort(byArray, 2 + n, (short)16);
        LittleEndian.putShort(byArray, 4 + n, (short)this.getRowNumber());
        LittleEndian.putShort(byArray, 6 + n, this.getFirstCol() == -1 ? (short)0 : this.getFirstCol());
        LittleEndian.putShort(byArray, 8 + n, this.getLastCol() == -1 ? (short)0 : this.getLastCol());
        LittleEndian.putShort(byArray, 10 + n, this.getHeight());
        LittleEndian.putShort(byArray, 12 + n, this.getOptimize());
        LittleEndian.putShort(byArray, 14 + n, this.field_6_reserved);
        LittleEndian.putShort(byArray, 16 + n, this.getOptionFlags());
        LittleEndian.putShort(byArray, 18 + n, this.getXFIndex());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 20;
    }

    public short getSid() {
        return 520;
    }

    public int compareTo(Object object) {
        RowRecord rowRecord = (RowRecord)object;
        if (this.getRowNumber() == rowRecord.getRowNumber()) {
            return 0;
        }
        if (this.getRowNumber() < rowRecord.getRowNumber()) {
            return -1;
        }
        if (this.getRowNumber() > rowRecord.getRowNumber()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RowRecord)) {
            return false;
        }
        RowRecord rowRecord = (RowRecord)object;
        return this.getRowNumber() == rowRecord.getRowNumber();
    }

    public Object clone() {
        RowRecord rowRecord = new RowRecord(this.field_1_row_number);
        rowRecord.field_2_first_col = this.field_2_first_col;
        rowRecord.field_3_last_col = this.field_3_last_col;
        rowRecord.field_4_height = this.field_4_height;
        rowRecord.field_5_optimize = this.field_5_optimize;
        rowRecord.field_6_reserved = this.field_6_reserved;
        rowRecord.field_7_option_flags = this.field_7_option_flags;
        rowRecord.field_8_xf_index = this.field_8_xf_index;
        return rowRecord;
    }
}

