/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class RefreshAllRecord
extends Record {
    public static final short sid = 439;
    private short field_1_refreshall;

    public RefreshAllRecord() {
    }

    public RefreshAllRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 439) {
            throw new RecordFormatException("NOT A REFRESHALL RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_refreshall = recordInputStream.readShort();
    }

    public void setRefreshAll(boolean bl) {
        this.field_1_refreshall = bl ? (short)1 : 0;
    }

    public boolean getRefreshAll() {
        return this.field_1_refreshall == 1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[REFRESHALL]\n");
        stringBuffer.append("    .refreshall      = ").append(this.getRefreshAll()).append("\n");
        stringBuffer.append("[/REFRESHALL]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)439);
        LittleEndian.putShort(byArray, 2 + n, (short)2);
        LittleEndian.putShort(byArray, 4 + n, this.field_1_refreshall);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 439;
    }
}

