/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.UnicodeString;
import com.fr.third.org.apache.poi.util.LittleEndian;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class RecordInputStream
extends InputStream {
    public static final short MAX_RECORD_DATA_SIZE = 8224;
    private InputStream in;
    protected short currentSid;
    protected short currentLength = (short)-1;
    protected short nextSid = (short)-1;
    protected byte[] data = new byte[8224];
    protected short recordOffset;
    protected long pos;
    private boolean autoContinue = true;
    byte[] NAN_data = null;

    public RecordInputStream(InputStream inputStream) throws RecordFormatException {
        this.in = inputStream;
        try {
            this.nextSid = LittleEndian.readShort(inputStream);
        }
        catch (IOException iOException) {
            throw new RecordFormatException("Error reading bytes", iOException);
        }
    }

    public int read() throws IOException {
        this.checkRecordPosition();
        byte by = this.data[this.recordOffset];
        this.recordOffset = (short)(this.recordOffset + 1);
        ++this.pos;
        return by;
    }

    public short getSid() {
        return this.currentSid;
    }

    public short getLength() {
        return this.currentLength;
    }

    public short getRecordOffset() {
        return this.recordOffset;
    }

    public long getPos() {
        return this.pos;
    }

    public boolean hasNextRecord() {
        return this.nextSid != 0;
    }

    public void nextRecord() throws RecordFormatException {
        if (this.currentLength != -1 && this.currentLength != this.recordOffset) {
            System.out.println("WARN. Unread " + this.remaining() + " bytes of record 0x" + Integer.toHexString(this.currentSid));
        }
        this.currentSid = this.nextSid;
        this.pos += 2L;
        this.autoContinue = true;
        try {
            this.recordOffset = 0;
            this.currentLength = LittleEndian.readShort(this.in);
            if (this.currentLength > 8224) {
                throw new RecordFormatException("The content of an excel record cannot exceed 8224 bytes");
            }
            this.pos += 2L;
            this.in.read(this.data, 0, this.currentLength);
            this.nextSid = LittleEndian.readShort(this.in);
        }
        catch (IOException iOException) {
            throw new RecordFormatException("Error reading bytes", iOException);
        }
    }

    public void setAutoContinue(boolean bl) {
        this.autoContinue = bl;
    }

    public boolean getAutoContinue() {
        return this.autoContinue;
    }

    protected void checkRecordPosition() {
        if (this.remaining() <= 0) {
            if (this.isContinueNext() && this.autoContinue) {
                this.nextRecord();
            } else {
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    public byte readByte() {
        this.checkRecordPosition();
        byte by = this.data[this.recordOffset];
        this.recordOffset = (short)(this.recordOffset + 1);
        ++this.pos;
        return by;
    }

    public short readShort() {
        this.checkRecordPosition();
        short s = LittleEndian.getShort(this.data, this.recordOffset);
        this.recordOffset = (short)(this.recordOffset + 2);
        this.pos += 2L;
        return s;
    }

    public int readInt() {
        this.checkRecordPosition();
        int n = LittleEndian.getInt(this.data, this.recordOffset);
        this.recordOffset = (short)(this.recordOffset + 4);
        this.pos += 4L;
        return n;
    }

    public long readLong() {
        this.checkRecordPosition();
        long l = LittleEndian.getLong(this.data, this.recordOffset);
        this.recordOffset = (short)(this.recordOffset + 8);
        this.pos += 8L;
        return l;
    }

    public short readUByte() {
        short s = this.readByte();
        if (s < 0) {
            s = (short)(s + 256);
        }
        return s;
    }

    public int readUShort() {
        this.checkRecordPosition();
        int n = LittleEndian.getUShort(this.data, this.recordOffset);
        this.recordOffset = (short)(this.recordOffset + 2);
        this.pos += 2L;
        return n;
    }

    public double readDouble() {
        this.checkRecordPosition();
        this.NAN_data = null;
        double d = LittleEndian.getDouble(this.data, this.recordOffset);
        if (Double.isNaN(d)) {
            this.NAN_data = new byte[8];
            System.arraycopy(this.data, this.recordOffset, this.NAN_data, 0, 8);
        }
        this.recordOffset = (short)(this.recordOffset + 8);
        this.pos += 8L;
        return d;
    }

    public byte[] getNANData() {
        if (this.NAN_data == null) {
            throw new RecordFormatException("Do NOT call getNANData without calling readDouble that returns NaN");
        }
        return this.NAN_data;
    }

    public short[] readShortArray() {
        this.checkRecordPosition();
        short[] sArray = LittleEndian.getShortArray(this.data, this.recordOffset);
        int n = 2 * (sArray.length + 1);
        this.recordOffset = (short)(this.recordOffset + n);
        this.pos += (long)n;
        return sArray;
    }

    public String readUnicodeLEString(int n) {
        if (n < 0 || this.remaining() / 2 < n && !this.isContinueNext()) {
            throw new IllegalArgumentException("Illegal length - asked for " + n + " but only " + this.remaining() / 2 + " left!");
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c;
            if (this.remaining() == 0 && this.isContinueNext()) {
                this.nextRecord();
                c = (char)this.readByte();
                if (c != '\u0001') {
                    throw new IllegalArgumentException("compressByte in continue records must be 1 while reading unicode LE string");
                }
            }
            c = (char)this.readShort();
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String readCompressedUnicode(int n) {
        if (n == 0) {
            return "";
        }
        if (n < 0 || this.remaining() < n && !this.isContinueNext()) {
            throw new IllegalArgumentException("Illegal length " + n);
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            byte by;
            if (this.remaining() == 0 && this.isContinueNext()) {
                this.nextRecord();
                by = this.readByte();
                if (by != 0) {
                    throw new IllegalArgumentException("compressByte in continue records must be 0 while reading compressed unicode");
                }
            }
            by = this.readByte();
            char c = (char)(0xFF & (short)by);
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public UnicodeString readUnicodeString() {
        return new UnicodeString(this);
    }

    public byte[] readRemainder() {
        int n = this.remaining();
        byte[] byArray = new byte[n];
        System.arraycopy(this.data, this.recordOffset, byArray, 0, n);
        this.recordOffset = (short)(this.recordOffset + n);
        this.pos += (long)n;
        return byArray;
    }

    public byte[] readAllContinuedRemainder() {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16448);
        while (this.isContinueNext()) {
            byArray = this.readRemainder();
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            this.nextRecord();
        }
        byArray = this.readRemainder();
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        return byteArrayOutputStream.toByteArray();
    }

    public int remaining() {
        return this.currentLength - this.recordOffset;
    }

    public boolean isContinueNext() {
        return this.nextSid == 60;
    }
}

