/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.RecordFactory;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import java.io.ByteArrayInputStream;

public abstract class Record {
    public Record() {
    }

    public Record(RecordInputStream recordInputStream) {
        this.validateSid(recordInputStream.getSid());
        this.fillFields(recordInputStream);
    }

    protected abstract void validateSid(short var1);

    protected abstract void fillFields(RecordInputStream var1);

    public byte[] serialize() {
        byte[] byArray = new byte[this.getRecordSize()];
        this.serialize(0, byArray);
        return byArray;
    }

    public abstract int serialize(int var1, byte[] var2);

    public int getRecordSize() {
        return this.serialize().length;
    }

    public boolean isValue() {
        return false;
    }

    public boolean isInValueSection() {
        return false;
    }

    public String toString() {
        return super.toString();
    }

    public abstract short getSid();

    public Object clone() {
        throw new RuntimeException("The class " + this.getClass().getName() + " needs to define a clone method");
    }

    public Record cloneViaReserialise() {
        byte[] byArray = this.serialize();
        RecordInputStream recordInputStream = new RecordInputStream(new ByteArrayInputStream(byArray));
        recordInputStream.nextRecord();
        Record[] recordArray = RecordFactory.createRecord(recordInputStream);
        if (recordArray.length != 1) {
            throw new IllegalStateException("Re-serialised a record to clone it, but got " + recordArray.length + " records back!");
        }
        return recordArray[0];
    }
}

