/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class RecalcIdRecord
extends Record {
    public static final short sid = 449;
    public short[] field_1_recalcids;
    private boolean isNeeded = true;

    public RecalcIdRecord() {
    }

    public RecalcIdRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 449) {
            throw new RecordFormatException("NOT A RECALCID RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_recalcids = new short[recordInputStream.remaining() / 2];
        for (int i = 0; i < this.field_1_recalcids.length; ++i) {
            this.field_1_recalcids[i] = recordInputStream.readShort();
        }
    }

    public void setRecalcIdArray(short[] sArray) {
        this.field_1_recalcids = sArray;
    }

    public short[] getRecalcIdArray() {
        return this.field_1_recalcids;
    }

    public void setIsNeeded(boolean bl) {
        this.isNeeded = bl;
    }

    public boolean isNeeded() {
        return this.isNeeded;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[RECALCID]\n");
        stringBuffer.append("    .elements        = ").append(this.field_1_recalcids.length).append("\n");
        for (int i = 0; i < this.field_1_recalcids.length; ++i) {
            stringBuffer.append("    .element_" + i + "       = ").append(this.field_1_recalcids[i]).append("\n");
        }
        stringBuffer.append("[/RECALCID]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        short[] sArray = this.getRecalcIdArray();
        short s = (short)(sArray.length * 2);
        int n2 = 4;
        LittleEndian.putShort(byArray, 0 + n, (short)449);
        LittleEndian.putShort(byArray, 2 + n, s);
        for (int i = 0; i < s / 2; ++i) {
            LittleEndian.putShort(byArray, n2 + n, sArray[i]);
            n2 += 2;
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 4 + this.getRecalcIdArray().length * 2;
    }

    public short getSid() {
        return 449;
    }
}

