/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.CellValueRecordInterface;
import com.fr.third.org.apache.poi.hssf.record.NumberRecord;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.util.RKUtil;

public class RKRecord
extends Record
implements CellValueRecordInterface {
    public static final short sid = 638;
    public static final short RK_IEEE_NUMBER = 0;
    public static final short RK_IEEE_NUMBER_TIMES_100 = 1;
    public static final short RK_INTEGER = 2;
    public static final short RK_INTEGER_TIMES_100 = 3;
    private int field_1_row;
    private short field_2_col;
    private short field_3_xf_index;
    private int field_4_rk_number;

    public RKRecord() {
    }

    public RKRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 638) {
            throw new RecordFormatException("NOT A valid RK RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_row = recordInputStream.readUShort();
        this.field_2_col = recordInputStream.readShort();
        this.field_3_xf_index = recordInputStream.readShort();
        this.field_4_rk_number = recordInputStream.readInt();
    }

    public int getRow() {
        return this.field_1_row;
    }

    public short getColumn() {
        return this.field_2_col;
    }

    public short getXFIndex() {
        return this.field_3_xf_index;
    }

    public int getRKField() {
        return this.field_4_rk_number;
    }

    public short getRKType() {
        return (short)(this.field_4_rk_number & 3);
    }

    public double getRKNumber() {
        return RKUtil.decodeNumber(this.field_4_rk_number);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[RK]\n");
        stringBuffer.append("    .row            = ").append(Integer.toHexString(this.getRow())).append("\n");
        stringBuffer.append("    .col            = ").append(Integer.toHexString(this.getColumn())).append("\n");
        stringBuffer.append("    .xfindex        = ").append(Integer.toHexString(this.getXFIndex())).append("\n");
        stringBuffer.append("    .rknumber       = ").append(Integer.toHexString(this.getRKField())).append("\n");
        stringBuffer.append("        .rktype     = ").append(Integer.toHexString(this.getRKType())).append("\n");
        stringBuffer.append("        .rknumber   = ").append(this.getRKNumber()).append("\n");
        stringBuffer.append("[/RK]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        NumberRecord numberRecord = new NumberRecord();
        numberRecord.setColumn(this.getColumn());
        numberRecord.setRow(this.getRow());
        numberRecord.setValue(this.getRKNumber());
        numberRecord.setXFIndex(this.getXFIndex());
        return numberRecord.serialize(n, byArray);
    }

    public static void main(String[] stringArray) {
        int[] nArray = new int[]{0x3FF00000, 1079951361, 49382714, 49382715, -52598374};
        double[] dArray = new double[]{1.0, 1.23, 1.2345678E7, 123456.78, -1.3149594E7};
        for (int i = 0; i < nArray.length; ++i) {
            System.out.println("input = " + Integer.toHexString(nArray[i]) + " -> " + dArray[i] + ": " + RKUtil.decodeNumber(nArray[i]));
        }
    }

    public short getSid() {
        return 638;
    }

    public boolean isBefore(CellValueRecordInterface cellValueRecordInterface) {
        if (this.getRow() > cellValueRecordInterface.getRow()) {
            return false;
        }
        if (this.getRow() == cellValueRecordInterface.getRow() && this.getColumn() > cellValueRecordInterface.getColumn()) {
            return false;
        }
        return this.getRow() != cellValueRecordInterface.getRow() || this.getColumn() != cellValueRecordInterface.getColumn();
    }

    public boolean isAfter(CellValueRecordInterface cellValueRecordInterface) {
        if (this.getRow() < cellValueRecordInterface.getRow()) {
            return false;
        }
        if (this.getRow() == cellValueRecordInterface.getRow() && this.getColumn() < cellValueRecordInterface.getColumn()) {
            return false;
        }
        return this.getRow() != cellValueRecordInterface.getRow() || this.getColumn() != cellValueRecordInterface.getColumn();
    }

    public boolean isEqual(CellValueRecordInterface cellValueRecordInterface) {
        return this.getRow() == cellValueRecordInterface.getRow() && this.getColumn() == cellValueRecordInterface.getColumn();
    }

    public boolean isInValueSection() {
        return true;
    }

    public boolean isValue() {
        return true;
    }

    public void setColumn(short s) {
    }

    public void setRow(int n) {
    }

    public void setXFIndex(short s) {
    }

    public Object clone() {
        RKRecord rKRecord = new RKRecord();
        rKRecord.field_1_row = this.field_1_row;
        rKRecord.field_2_col = this.field_2_col;
        rKRecord.field_3_xf_index = this.field_3_xf_index;
        rKRecord.field_4_rk_number = this.field_4_rk_number;
        return rKRecord;
    }
}

