/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class PrecisionRecord
extends Record {
    public static final short sid = 14;
    public short field_1_precision;

    public PrecisionRecord() {
    }

    public PrecisionRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 14) {
            throw new RecordFormatException("NOT A PRECISION RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_precision = recordInputStream.readShort();
    }

    public void setFullPrecision(boolean bl) {
        this.field_1_precision = bl ? (short)1 : 0;
    }

    public boolean getFullPrecision() {
        return this.field_1_precision == 1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[PRECISION]\n");
        stringBuffer.append("    .precision       = ").append(this.getFullPrecision()).append("\n");
        stringBuffer.append("[/PRECISION]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)14);
        LittleEndian.putShort(byArray, 2 + n, (short)2);
        LittleEndian.putShort(byArray, 4 + n, this.field_1_precision);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 14;
    }
}

