/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class PasswordRecord
extends Record {
    public static final short sid = 19;
    private short field_1_password;

    public PasswordRecord() {
    }

    public PasswordRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 19) {
            throw new RecordFormatException("NOT A PASSWORD RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_password = recordInputStream.readShort();
    }

    public static short hashPassword(String string) {
        byte[] byArray = string.getBytes();
        int n = 0;
        if (byArray.length > 0) {
            int n2 = byArray.length;
            while (n2-- > 0) {
                n = n >> 14 & 1 | n << 1 & Short.MAX_VALUE;
                n ^= byArray[n2];
            }
            n = n >> 14 & 1 | n << 1 & Short.MAX_VALUE;
            n ^= byArray.length;
            n ^= 0xCE4B;
        }
        return (short)n;
    }

    public void setPassword(short s) {
        this.field_1_password = s;
    }

    public short getPassword() {
        return this.field_1_password;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[PASSWORD]\n");
        stringBuffer.append("    .password       = ").append(Integer.toHexString(this.getPassword())).append("\n");
        stringBuffer.append("[/PASSWORD]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)19);
        LittleEndian.putShort(byArray, 2 + n, (short)2);
        LittleEndian.putShort(byArray, 4 + n, this.getPassword());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 19;
    }

    public Object clone() {
        PasswordRecord passwordRecord = new PasswordRecord();
        passwordRecord.setPassword(this.field_1_password);
        return passwordRecord;
    }
}

