/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.PColor;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;
import java.util.ArrayList;
import java.util.List;

public class PaletteRecord
extends Record {
    public static final short sid = 146;
    public static final byte STANDARD_PALETTE_SIZE = 56;
    public static final short FIRST_COLOR_INDEX = 8;
    private short field_1_numcolors;
    private List field_2_colors;

    public PaletteRecord() {
        this.createDefaultPalette();
    }

    public PaletteRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 146) {
            throw new RecordFormatException("NOT An Palette RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_numcolors = recordInputStream.readShort();
        this.field_2_colors = new ArrayList(this.field_1_numcolors);
        for (int i = 0; i < this.field_1_numcolors; ++i) {
            this.field_2_colors.add(new PColor(recordInputStream.readByte(), recordInputStream.readByte(), recordInputStream.readByte()));
            recordInputStream.readByte();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[PALETTE]\n");
        stringBuffer.append("  numcolors     = ").append(this.field_1_numcolors).append('\n');
        for (int i = 0; i < this.field_1_numcolors; ++i) {
            PColor pColor = (PColor)this.field_2_colors.get(i);
            stringBuffer.append("* colornum      = ").append(i).append('\n');
            stringBuffer.append(pColor.toString());
            stringBuffer.append("/*colornum      = ").append(i).append('\n');
        }
        stringBuffer.append("[/PALETTE]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)146);
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(byArray, 4 + n, this.field_1_numcolors);
        for (int i = 0; i < this.field_1_numcolors; ++i) {
            PColor pColor = (PColor)this.field_2_colors.get(i);
            pColor.serialize(byArray, 6 + n + i * 4);
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6 + this.field_1_numcolors * 4;
    }

    public short getSid() {
        return 146;
    }

    public byte[] getColor(short s) {
        int n = s - 8;
        if (n < 0 || n >= this.field_2_colors.size()) {
            return null;
        }
        PColor pColor = (PColor)this.field_2_colors.get(n);
        return new byte[]{pColor.red, pColor.green, pColor.blue};
    }

    public void setColor(short s, byte by, byte by2, byte by3) {
        int n = s - 8;
        if (n < 0 || n >= 56) {
            return;
        }
        while (this.field_2_colors.size() <= n) {
            this.field_2_colors.add(new PColor(0, 0, 0));
        }
        PColor pColor = new PColor(by, by2, by3);
        this.field_2_colors.set(n, pColor);
    }

    private void createDefaultPalette() {
        this.field_1_numcolors = (short)56;
        this.field_2_colors = new ArrayList(this.field_1_numcolors);
        byte[] byArray = new byte[]{0, 0, 0, 0, -1, -1, -1, 0, -1, 0, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, -1, 0, 0, -1, 0, -1, 0, 0, -1, -1, 0, -128, 0, 0, 0, 0, -128, 0, 0, 0, 0, -128, 0, -128, -128, 0, 0, -128, 0, -128, 0, 0, -128, -128, 0, -64, -64, -64, 0, -128, -128, -128, 0, -103, -103, -1, 0, -103, 51, 102, 0, -1, -1, -52, 0, -52, -1, -1, 0, 102, 0, 102, 0, -1, -128, -128, 0, 0, 102, -52, 0, -52, -52, -1, 0, 0, 0, -128, 0, -1, 0, -1, 0, -1, -1, 0, 0, 0, -1, -1, 0, -128, 0, -128, 0, -128, 0, 0, 0, 0, -128, -128, 0, 0, 0, -1, 0, 0, -52, -1, 0, -52, -1, -1, 0, -52, -1, -52, 0, -1, -1, -103, 0, -103, -52, -1, 0, -1, -103, -52, 0, -52, -103, -1, 0, -1, -52, -103, 0, 51, 102, -1, 0, 51, -52, -52, 0, -103, -52, 0, 0, -1, -52, 0, 0, -1, -103, 0, 0, -1, 102, 0, 0, 102, 102, -103, 0, -106, -106, -106, 0, 0, 51, 102, 0, 51, -103, 102, 0, 0, 51, 0, 0, 51, 51, 0, 0, -103, 51, 0, 0, -103, 51, 102, 0, 51, 51, -103, 0, 51, 51, 51, 0};
        for (int i = 0; i < this.field_1_numcolors; ++i) {
            this.field_2_colors.add(new PColor(byArray[i * 4], byArray[i * 4 + 1], byArray[i * 4 + 2]));
        }
    }
}

