/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PageBreakRecord
extends Record {
    public static final short HORIZONTAL_SID = 27;
    public static final short VERTICAL_SID = 26;
    public short sid;
    private short numBreaks;
    private List breaks;
    private Map BreakMap;

    public PageBreakRecord() {
    }

    public PageBreakRecord(short s) {
        this.sid = s;
    }

    public PageBreakRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
        this.sid = recordInputStream.getSid();
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        int n = recordInputStream.readShort();
        this.setNumBreaks((short)n);
        for (int i = 0; i < n; ++i) {
            this.addBreak((short)(recordInputStream.readShort() - 1), recordInputStream.readShort(), recordInputStream.readShort());
        }
    }

    public short getSid() {
        return this.sid;
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = this.getRecordSize();
        int n3 = 6;
        LittleEndian.putShort(byArray, n + 0, this.getSid());
        LittleEndian.putShort(byArray, n + 2, (short)(n2 - 4));
        LittleEndian.putShort(byArray, n + 4, this.getNumBreaks());
        Iterator iterator = this.getBreaksIterator();
        while (iterator.hasNext()) {
            Break break_ = (Break)iterator.next();
            LittleEndian.putShort(byArray, n + n3, (short)(break_.main + 1));
            LittleEndian.putShort(byArray, n + (n3 += 2), break_.subFrom);
            LittleEndian.putShort(byArray, n + (n3 += 2), break_.subTo);
            n3 += 2;
        }
        return n2;
    }

    protected void validateSid(short s) {
        if (s != 27 && s != 26) {
            throw new RecordFormatException("NOT A HorizontalPageBreak or VerticalPageBreak RECORD!! " + s);
        }
    }

    public short getNumBreaks() {
        return this.breaks != null ? (short)this.breaks.size() : this.numBreaks;
    }

    public void setNumBreaks(short s) {
        this.numBreaks = s;
    }

    public Iterator getBreaksIterator() {
        if (this.breaks == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.breaks.iterator();
    }

    public String toString() {
        String string;
        String string2;
        String string3;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getSid() != 27 && this.getSid() != 26) {
            return "[INVALIDPAGEBREAK]\n     .sid =" + this.getSid() + "[INVALIDPAGEBREAK]";
        }
        if (this.getSid() == 27) {
            string3 = "HORIZONTALPAGEBREAK";
            string2 = "row";
            string = "col";
        } else {
            string3 = "VERTICALPAGEBREAK";
            string2 = "column";
            string = "row";
        }
        stringBuffer.append("[" + string3 + "]").append("\n");
        stringBuffer.append("     .sid        =").append(this.getSid()).append("\n");
        stringBuffer.append("     .numbreaks =").append(this.getNumBreaks()).append("\n");
        Iterator iterator = this.getBreaksIterator();
        for (int i = 0; i < this.getNumBreaks(); ++i) {
            Break break_ = (Break)iterator.next();
            stringBuffer.append("     .").append(string2).append(" (zero-based) =").append(break_.main).append("\n");
            stringBuffer.append("     .").append(string).append("From    =").append(break_.subFrom).append("\n");
            stringBuffer.append("     .").append(string).append("To      =").append(break_.subTo).append("\n");
        }
        stringBuffer.append("[" + string3 + "]").append("\n");
        return stringBuffer.toString();
    }

    public void addBreak(short s, short s2, short s3) {
        Integer n;
        Break break_;
        if (this.breaks == null) {
            this.breaks = new ArrayList(this.getNumBreaks() + 10);
            this.BreakMap = new HashMap();
        }
        if ((break_ = (Break)this.BreakMap.get(n = new Integer(s))) != null) {
            break_.main = s;
            break_.subFrom = s2;
            break_.subTo = s3;
        } else {
            break_ = new Break(s, s2, s3);
            this.breaks.add(break_);
        }
        this.BreakMap.put(n, break_);
    }

    public void removeBreak(short s) {
        Integer n = new Integer(s);
        Break break_ = (Break)this.BreakMap.get(n);
        this.breaks.remove(break_);
        this.BreakMap.remove(n);
    }

    public int getRecordSize() {
        return 6 + this.getNumBreaks() * 6;
    }

    public Break getBreak(short s) {
        if (this.BreakMap == null) {
            return null;
        }
        Integer n = new Integer(s);
        return (Break)this.BreakMap.get(n);
    }

    public Object clone() {
        PageBreakRecord pageBreakRecord = new PageBreakRecord(this.getSid());
        Iterator iterator = this.getBreaksIterator();
        while (iterator.hasNext()) {
            Break break_ = (Break)iterator.next();
            pageBreakRecord.addBreak(break_.main, break_.subFrom, break_.subTo);
        }
        return pageBreakRecord;
    }

    public class Break {
        public short main;
        public short subFrom;
        public short subTo;

        public Break(short s, short s2, short s3) {
            this.main = s;
            this.subFrom = s2;
            this.subTo = s3;
        }
    }
}

