/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.EndSubRecord;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.SubRecord;
import com.fr.third.org.apache.poi.util.LittleEndian;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ObjRecord
extends Record {
    public static final short sid = 93;
    private List subrecords;

    public ObjRecord() {
        this.subrecords = new ArrayList(2);
    }

    public ObjRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 93) {
            throw new RecordFormatException("Not an OBJ record");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.subrecords = new ArrayList();
        int n = 0;
        byte[] byArray = recordInputStream.readRemainder();
        RecordInputStream recordInputStream2 = new RecordInputStream(new ByteArrayInputStream(byArray));
        while (recordInputStream2.hasNextRecord()) {
            recordInputStream2.nextRecord();
            Record record = SubRecord.createSubRecord(recordInputStream2);
            n += record.getRecordSize();
            this.subrecords.add(record);
        }
        if (byArray.length - n >= 4) {
            this.subrecords.add(new EndSubRecord());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[OBJ]\n");
        Iterator iterator = this.subrecords.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            stringBuffer.append("SUBRECORD: " + record.toString());
        }
        stringBuffer.append("[/OBJ]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = 0;
        LittleEndian.putShort(byArray, 0 + n, (short)93);
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        n2 = n + 4;
        Iterator iterator = this.subrecords.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            n2 += record.serialize(n2, byArray);
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        int n = 0;
        Iterator iterator = this.subrecords.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            n += record.getRecordSize();
        }
        int n2 = n & 3;
        int n3 = n2 == 0 ? 0 : 4 - n2;
        return 4 + n + n3;
    }

    public short getSid() {
        return 93;
    }

    public List getSubRecords() {
        return this.subrecords;
    }

    public void clearSubRecords() {
        this.subrecords.clear();
    }

    public void addSubRecord(int n, Object object) {
        this.subrecords.add(n, object);
    }

    public boolean addSubRecord(Object object) {
        return this.subrecords.add(object);
    }

    public Object clone() {
        ObjRecord objRecord = new ObjRecord();
        Iterator iterator = this.subrecords.iterator();
        while (iterator.hasNext()) {
            objRecord.addSubRecord(((Record)iterator.next()).clone());
        }
        return objRecord;
    }
}

