/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.CellValueRecordInterface;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class NumberRecord
extends Record
implements CellValueRecordInterface,
Comparable {
    public static final short sid = 515;
    private int field_1_row;
    private short field_2_col;
    private short field_3_xf;
    private double field_4_value;

    public NumberRecord() {
    }

    public NumberRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_row = recordInputStream.readUShort();
        this.field_2_col = recordInputStream.readShort();
        this.field_3_xf = recordInputStream.readShort();
        this.field_4_value = recordInputStream.readDouble();
    }

    public void setRow(int n) {
        this.field_1_row = n;
    }

    public void setColumn(short s) {
        this.field_2_col = s;
    }

    public void setXFIndex(short s) {
        this.field_3_xf = s;
    }

    public void setValue(double d) {
        this.field_4_value = d;
    }

    public int getRow() {
        return this.field_1_row;
    }

    public short getColumn() {
        return this.field_2_col;
    }

    public short getXFIndex() {
        return this.field_3_xf;
    }

    public double getValue() {
        return this.field_4_value;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[NUMBER]\n");
        stringBuffer.append("    .row            = ").append(Integer.toHexString(this.getRow())).append("\n");
        stringBuffer.append("    .col            = ").append(Integer.toHexString(this.getColumn())).append("\n");
        stringBuffer.append("    .xfindex        = ").append(Integer.toHexString(this.getXFIndex())).append("\n");
        stringBuffer.append("    .value          = ").append(this.getValue()).append("\n");
        stringBuffer.append("[/NUMBER]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)515);
        LittleEndian.putShort(byArray, 2 + n, (short)14);
        LittleEndian.putShort(byArray, 4 + n, (short)this.getRow());
        LittleEndian.putShort(byArray, 6 + n, this.getColumn());
        LittleEndian.putShort(byArray, 8 + n, this.getXFIndex());
        LittleEndian.putDouble(byArray, 10 + n, this.getValue());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 18;
    }

    protected void validateSid(short s) {
        if (s != 515) {
            throw new RecordFormatException("NOT A Number RECORD");
        }
    }

    public short getSid() {
        return 515;
    }

    public boolean isBefore(CellValueRecordInterface cellValueRecordInterface) {
        if (this.getRow() > cellValueRecordInterface.getRow()) {
            return false;
        }
        if (this.getRow() == cellValueRecordInterface.getRow() && this.getColumn() > cellValueRecordInterface.getColumn()) {
            return false;
        }
        return this.getRow() != cellValueRecordInterface.getRow() || this.getColumn() != cellValueRecordInterface.getColumn();
    }

    public boolean isAfter(CellValueRecordInterface cellValueRecordInterface) {
        if (this.getRow() < cellValueRecordInterface.getRow()) {
            return false;
        }
        if (this.getRow() == cellValueRecordInterface.getRow() && this.getColumn() < cellValueRecordInterface.getColumn()) {
            return false;
        }
        return this.getRow() != cellValueRecordInterface.getRow() || this.getColumn() != cellValueRecordInterface.getColumn();
    }

    public boolean isEqual(CellValueRecordInterface cellValueRecordInterface) {
        return this.getRow() == cellValueRecordInterface.getRow() && this.getColumn() == cellValueRecordInterface.getColumn();
    }

    public boolean isInValueSection() {
        return true;
    }

    public boolean isValue() {
        return true;
    }

    public int compareTo(Object object) {
        CellValueRecordInterface cellValueRecordInterface = (CellValueRecordInterface)object;
        if (this.getRow() == cellValueRecordInterface.getRow() && this.getColumn() == cellValueRecordInterface.getColumn()) {
            return 0;
        }
        if (this.getRow() < cellValueRecordInterface.getRow()) {
            return -1;
        }
        if (this.getRow() > cellValueRecordInterface.getRow()) {
            return 1;
        }
        if (this.getColumn() < cellValueRecordInterface.getColumn()) {
            return -1;
        }
        if (this.getColumn() > cellValueRecordInterface.getColumn()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CellValueRecordInterface)) {
            return false;
        }
        CellValueRecordInterface cellValueRecordInterface = (CellValueRecordInterface)object;
        return this.getRow() == cellValueRecordInterface.getRow() && this.getColumn() == cellValueRecordInterface.getColumn();
    }

    public Object clone() {
        NumberRecord numberRecord = new NumberRecord();
        numberRecord.field_1_row = this.field_1_row;
        numberRecord.field_2_col = this.field_2_col;
        numberRecord.field_3_xf = this.field_3_xf;
        numberRecord.field_4_value = this.field_4_value;
        return numberRecord;
    }
}

