/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.SubRecord;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class NoteStructureSubRecord
extends SubRecord {
    public static final short sid = 13;
    private byte[] reserved;

    public NoteStructureSubRecord() {
        this.reserved = new byte[22];
    }

    public NoteStructureSubRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 13) {
            throw new RecordFormatException("Not a Note Structure record");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.reserved = recordInputStream.readRemainder();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("[ftNts ]" + string);
        stringBuffer.append("  size     = ").append(this.getRecordSize()).append(string);
        stringBuffer.append("  reserved = ").append(HexDump.toHex(this.reserved)).append(string);
        stringBuffer.append("[/ftNts ]" + string);
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)13);
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        System.arraycopy(this.reserved, 0, byArray, n + 4, this.getRecordSize() - 4);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 4 + this.reserved.length;
    }

    public short getSid() {
        return 13;
    }

    public Object clone() {
        NoteStructureSubRecord noteStructureSubRecord = new NoteStructureSubRecord();
        byte[] byArray = new byte[this.reserved.length];
        System.arraycopy(this.reserved, 0, byArray, 0, byArray.length);
        noteStructureSubRecord.reserved = byArray;
        return noteStructureSubRecord;
    }
}

