/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class NoteRecord
extends Record {
    public static final short sid = 28;
    public static final short NOTE_HIDDEN = 0;
    public static final short NOTE_VISIBLE = 2;
    private short field_1_row;
    private short field_2_col;
    private short field_3_flags;
    private short field_4_shapeid;
    private String field_5_author;

    public NoteRecord() {
        this.field_5_author = "";
        this.field_3_flags = 0;
    }

    public NoteRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    public short getSid() {
        return 28;
    }

    protected void validateSid(short s) {
        if (s != 28) {
            throw new RecordFormatException("Not a NoteRecord record");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_row = recordInputStream.readShort();
        this.field_2_col = recordInputStream.readShort();
        this.field_3_flags = recordInputStream.readShort();
        this.field_4_shapeid = recordInputStream.readShort();
        short s = recordInputStream.readShort();
        byte[] byArray = recordInputStream.readRemainder();
        this.field_5_author = new String(byArray, 1, (int)s);
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)28);
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(byArray, 4 + n, this.field_1_row);
        LittleEndian.putShort(byArray, 6 + n, this.field_2_col);
        LittleEndian.putShort(byArray, 8 + n, this.field_3_flags);
        LittleEndian.putShort(byArray, 10 + n, this.field_4_shapeid);
        LittleEndian.putShort(byArray, 12 + n, (short)this.field_5_author.length());
        byte[] byArray2 = this.field_5_author.getBytes();
        System.arraycopy(byArray2, 0, byArray, 15 + n, byArray2.length);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        int n = 15 + this.field_5_author.length() + 1;
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[NOTE]\n");
        stringBuffer.append("    .recordid = 0x" + Integer.toHexString(this.getSid()) + ", size = " + this.getRecordSize() + "\n");
        stringBuffer.append("    .row =     " + this.field_1_row + "\n");
        stringBuffer.append("    .col =     " + this.field_2_col + "\n");
        stringBuffer.append("    .flags =   " + this.field_3_flags + "\n");
        stringBuffer.append("    .shapeid = " + this.field_4_shapeid + "\n");
        stringBuffer.append("    .author =  " + this.field_5_author + "\n");
        stringBuffer.append("[/NOTE]\n");
        return stringBuffer.toString();
    }

    public short getRow() {
        return this.field_1_row;
    }

    public void setRow(short s) {
        this.field_1_row = s;
    }

    public short getColumn() {
        return this.field_2_col;
    }

    public void setColumn(short s) {
        this.field_2_col = s;
    }

    public short getFlags() {
        return this.field_3_flags;
    }

    public void setFlags(short s) {
        this.field_3_flags = s;
    }

    public short getShapeId() {
        return this.field_4_shapeid;
    }

    public void setShapeId(short s) {
        this.field_4_shapeid = s;
    }

    public String getAuthor() {
        return this.field_5_author;
    }

    public void setAuthor(String string) {
        this.field_5_author = string;
    }

    public Object clone() {
        NoteRecord noteRecord = new NoteRecord();
        noteRecord.field_1_row = this.field_1_row;
        noteRecord.field_2_col = this.field_2_col;
        noteRecord.field_3_flags = this.field_3_flags;
        noteRecord.field_4_shapeid = this.field_4_shapeid;
        noteRecord.field_5_author = this.field_5_author;
        return noteRecord;
    }
}

