/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.model.FormulaParser;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.formula.Area3DPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.Ptg;
import com.fr.third.org.apache.poi.hssf.record.formula.Ref3DPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.UnionPtg;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.hssf.util.AreaReference;
import com.fr.third.org.apache.poi.hssf.util.RangeAddress;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;
import com.fr.third.org.apache.poi.util.StringUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public final class NameRecord
extends Record {
    public static final short sid = 24;
    public static final byte BUILTIN_CONSOLIDATE_AREA = 1;
    public static final byte BUILTIN_AUTO_OPEN = 2;
    public static final byte BUILTIN_AUTO_CLOSE = 3;
    public static final byte BUILTIN_DATABASE = 4;
    public static final byte BUILTIN_CRITERIA = 5;
    public static final byte BUILTIN_PRINT_AREA = 6;
    public static final byte BUILTIN_PRINT_TITLE = 7;
    public static final byte BUILTIN_RECORDER = 8;
    public static final byte BUILTIN_DATA_FORM = 9;
    public static final byte BUILTIN_AUTO_ACTIVATE = 10;
    public static final byte BUILTIN_AUTO_DEACTIVATE = 11;
    public static final byte BUILTIN_SHEET_TITLE = 12;
    public static final short OPT_HIDDEN_NAME = 1;
    public static final short OPT_FUNCTION_NAME = 2;
    public static final short OPT_COMMAND_NAME = 4;
    public static final short OPT_MACRO = 8;
    public static final short OPT_COMPLEX = 16;
    public static final short OPT_BUILTIN = 32;
    public static final short OPT_BINDATA = 4096;
    private short field_1_option_flag;
    private byte field_2_keyboard_shortcut;
    private byte field_3_length_name_text;
    private short field_4_length_name_definition;
    private short field_5_index_to_sheet;
    private short field_6_equals_to_index_to_sheet;
    private byte field_7_length_custom_menu;
    private byte field_8_length_description_text;
    private byte field_9_length_help_topic_text;
    private byte field_10_length_status_bar_text;
    private byte field_11_compressed_unicode_flag;
    private byte field_12_builtIn_name;
    private String field_12_name_text;
    private Stack field_13_name_definition;
    private String field_14_custom_menu_text;
    private String field_15_description_text;
    private String field_16_help_topic_text;
    private String field_17_status_bar_text;
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$hssf$record$formula$Area3DPtg;
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$hssf$record$formula$Ref3DPtg;

    public NameRecord() {
        this.field_13_name_definition = new Stack();
        this.field_12_name_text = new String();
        this.field_14_custom_menu_text = new String();
        this.field_15_description_text = new String();
        this.field_16_help_topic_text = new String();
        this.field_17_status_bar_text = new String();
    }

    public NameRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    public NameRecord(byte by, short s) {
        this();
        this.field_12_builtIn_name = by;
        this.setOptionFlag((short)(this.getOptionFlag() | 0x20));
        this.setNameTextLength((byte)1);
        this.setEqualsToIndexToSheet(s);
        this.setCustomMenuLength((byte)0);
        this.setDescriptionTextLength((byte)0);
        this.setHelpTopicLength((byte)0);
        this.setStatusBarLength((byte)0);
    }

    public void setOptionFlag(short s) {
        this.field_1_option_flag = s;
    }

    public void setKeyboardShortcut(byte by) {
        this.field_2_keyboard_shortcut = by;
    }

    public void setNameTextLength(byte by) {
        this.field_3_length_name_text = by;
    }

    public void setDefinitionTextLength(short s) {
        this.field_4_length_name_definition = s;
    }

    public void setUnused(short s) {
        this.field_5_index_to_sheet = s;
    }

    public short getEqualsToIndexToSheet() {
        return this.field_6_equals_to_index_to_sheet;
    }

    public short getIndexToSheet() {
        return this.getEqualsToIndexToSheet();
    }

    public byte getFnGroup() {
        int n = this.field_1_option_flag & 0xFC0;
        return (byte)(n >> 4);
    }

    public void setEqualsToIndexToSheet(short s) {
        this.field_6_equals_to_index_to_sheet = s;
    }

    public void setCustomMenuLength(byte by) {
        this.field_7_length_custom_menu = by;
    }

    public void setDescriptionTextLength(byte by) {
        this.field_8_length_description_text = by;
    }

    public void setHelpTopicLength(byte by) {
        this.field_9_length_help_topic_text = by;
    }

    public void setStatusBarLength(byte by) {
        this.field_10_length_status_bar_text = by;
    }

    public void setCompressedUnicodeFlag(byte by) {
        this.field_11_compressed_unicode_flag = by;
    }

    public void setNameText(String string) {
        this.field_12_name_text = string;
        this.setCompressedUnicodeFlag(StringUtil.hasMultibyte(string) ? (byte)1 : 0);
    }

    public void setCustomMenuText(String string) {
        this.field_14_custom_menu_text = string;
    }

    public void setDescriptionText(String string) {
        this.field_15_description_text = string;
    }

    public void setHelpTopicText(String string) {
        this.field_16_help_topic_text = string;
    }

    public void setStatusBarText(String string) {
        this.field_17_status_bar_text = string;
    }

    public short getOptionFlag() {
        return this.field_1_option_flag;
    }

    public byte getKeyboardShortcut() {
        return this.field_2_keyboard_shortcut;
    }

    public byte getNameTextLength() {
        return this.field_3_length_name_text;
    }

    public byte getRawNameTextLength() {
        if ((this.field_11_compressed_unicode_flag & 1) == 1) {
            return (byte)(2 * this.field_3_length_name_text);
        }
        return this.field_3_length_name_text;
    }

    public short getDefinitionLength() {
        return this.field_4_length_name_definition;
    }

    public short getUnused() {
        return this.field_5_index_to_sheet;
    }

    public byte getCustomMenuLength() {
        return this.field_7_length_custom_menu;
    }

    public byte getDescriptionTextLength() {
        return this.field_8_length_description_text;
    }

    public byte getHelpTopicLength() {
        return this.field_9_length_help_topic_text;
    }

    public byte getStatusBarLength() {
        return this.field_10_length_status_bar_text;
    }

    public byte getCompressedUnicodeFlag() {
        return this.field_11_compressed_unicode_flag;
    }

    public boolean isHiddenName() {
        return (this.field_1_option_flag & 1) != 0;
    }

    public boolean isFunctionName() {
        return (this.field_1_option_flag & 2) != 0;
    }

    public boolean isCommandName() {
        return (this.field_1_option_flag & 4) != 0;
    }

    public boolean isMacro() {
        return (this.field_1_option_flag & 8) != 0;
    }

    public boolean isComplexFunction() {
        return (this.field_1_option_flag & 0x10) != 0;
    }

    public boolean isBuiltInName() {
        return (this.getOptionFlag() & 0x20) != 0;
    }

    public String getNameText() {
        return this.isBuiltInName() ? this.translateBuiltInName(this.getBuiltInName()) : this.field_12_name_text;
    }

    public byte getBuiltInName() {
        return this.field_12_builtIn_name;
    }

    public List getNameDefinition() {
        return this.field_13_name_definition;
    }

    public void setNameDefinition(Stack stack) {
        this.field_13_name_definition = stack;
    }

    public String getCustomMenuText() {
        return this.field_14_custom_menu_text;
    }

    public String getDescriptionText() {
        return this.field_15_description_text;
    }

    public String getHelpTopicText() {
        return this.field_16_help_topic_text;
    }

    public String getStatusBarText() {
        return this.field_17_status_bar_text;
    }

    protected void validateSid(short s) {
        if (s != 24) {
            throw new RecordFormatException("NOT A valid Name RECORD");
        }
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)24);
        short s = (short)(15 + this.getTextsLength() + this.getNameDefinitionSize());
        LittleEndian.putShort(byArray, 2 + n, s);
        LittleEndian.putShort(byArray, 4 + n, this.getOptionFlag());
        byArray[6 + n] = this.getKeyboardShortcut();
        byArray[7 + n] = this.getNameTextLength();
        LittleEndian.putShort(byArray, 8 + n, this.getDefinitionLength());
        LittleEndian.putShort(byArray, 10 + n, this.getUnused());
        LittleEndian.putShort(byArray, 12 + n, this.getEqualsToIndexToSheet());
        byArray[14 + n] = this.getCustomMenuLength();
        byArray[15 + n] = this.getDescriptionTextLength();
        byArray[16 + n] = this.getHelpTopicLength();
        byArray[17 + n] = this.getStatusBarLength();
        byArray[18 + n] = this.getCompressedUnicodeFlag();
        int n2 = 19 + this.field_3_length_name_text;
        if (this.isBuiltInName()) {
            byArray[19 + n] = this.getBuiltInName();
        } else if ((this.getCompressedUnicodeFlag() & 1) == 1) {
            StringUtil.putUnicodeLE(this.getNameText(), byArray, 19 + n);
            n2 = 19 + 2 * this.field_3_length_name_text;
        } else {
            StringUtil.putCompressedUnicode(this.getNameText(), byArray, 19 + n);
        }
        Ptg.serializePtgStack(this.field_13_name_definition, byArray, n2 + n);
        int n3 = n2 + this.field_4_length_name_definition;
        StringUtil.putCompressedUnicode(this.getCustomMenuText(), byArray, n3 + n);
        int n4 = n3 + this.field_7_length_custom_menu;
        StringUtil.putCompressedUnicode(this.getDescriptionText(), byArray, n4 + n);
        int n5 = n4 + this.field_8_length_description_text;
        StringUtil.putCompressedUnicode(this.getHelpTopicText(), byArray, n5 + n);
        int n6 = n5 + this.field_9_length_help_topic_text;
        StringUtil.putCompressedUnicode(this.getStatusBarText(), byArray, n6 + n);
        return this.getRecordSize();
    }

    public int getTextsLength() {
        int n = this.getRawNameTextLength() + this.getDescriptionTextLength() + this.getHelpTopicLength() + this.getStatusBarLength();
        return n;
    }

    private int getNameDefinitionSize() {
        int n = 0;
        Stack stack = this.field_13_name_definition;
        for (int i = 0; i < stack.size(); ++i) {
            Ptg ptg = (Ptg)stack.get(i);
            n += ptg.getSize();
        }
        return n;
    }

    public int getRecordSize() {
        int n = 19 + this.getTextsLength() + this.getNameDefinitionSize();
        return n;
    }

    public short getExternSheetNumber() {
        if (this.field_13_name_definition == null || this.field_13_name_definition.isEmpty()) {
            return 0;
        }
        Ptg ptg = (Ptg)this.field_13_name_definition.peek();
        short s = 0;
        if (ptg.getClass() == (class$com$fr$third$org$apache$poi$hssf$record$formula$Area3DPtg == null ? (class$com$fr$third$org$apache$poi$hssf$record$formula$Area3DPtg = NameRecord.class$("com.fr.third.org.apache.poi.hssf.record.formula.Area3DPtg")) : class$com$fr$third$org$apache$poi$hssf$record$formula$Area3DPtg)) {
            s = ((Area3DPtg)ptg).getExternSheetIndex();
        } else if (ptg.getClass() == (class$com$fr$third$org$apache$poi$hssf$record$formula$Ref3DPtg == null ? (class$com$fr$third$org$apache$poi$hssf$record$formula$Ref3DPtg = NameRecord.class$("com.fr.third.org.apache.poi.hssf.record.formula.Ref3DPtg")) : class$com$fr$third$org$apache$poi$hssf$record$formula$Ref3DPtg)) {
            s = ((Ref3DPtg)ptg).getExternSheetIndex();
        }
        return s;
    }

    public void setExternSheetNumber(short s) {
        Ptg ptg;
        if (this.field_13_name_definition == null || this.field_13_name_definition.isEmpty()) {
            this.field_13_name_definition = new Stack();
            ptg = this.createNewPtg();
        } else {
            ptg = (Ptg)this.field_13_name_definition.peek();
        }
        if (ptg.getClass() == (class$com$fr$third$org$apache$poi$hssf$record$formula$Area3DPtg == null ? (class$com$fr$third$org$apache$poi$hssf$record$formula$Area3DPtg = NameRecord.class$("com.fr.third.org.apache.poi.hssf.record.formula.Area3DPtg")) : class$com$fr$third$org$apache$poi$hssf$record$formula$Area3DPtg)) {
            ((Area3DPtg)ptg).setExternSheetIndex(s);
        } else if (ptg.getClass() == (class$com$fr$third$org$apache$poi$hssf$record$formula$Ref3DPtg == null ? (class$com$fr$third$org$apache$poi$hssf$record$formula$Ref3DPtg = NameRecord.class$("com.fr.third.org.apache.poi.hssf.record.formula.Ref3DPtg")) : class$com$fr$third$org$apache$poi$hssf$record$formula$Ref3DPtg)) {
            ((Ref3DPtg)ptg).setExternSheetIndex(s);
        }
    }

    private Ptg createNewPtg() {
        Area3DPtg area3DPtg = new Area3DPtg();
        this.field_13_name_definition.push(area3DPtg);
        return area3DPtg;
    }

    public String getAreaReference(HSSFWorkbook hSSFWorkbook) {
        return FormulaParser.toFormulaString(hSSFWorkbook, this.field_13_name_definition);
    }

    public void setAreaReference(String string) {
        Ptg ptg;
        RangeAddress rangeAddress = new RangeAddress(string);
        if (this.field_13_name_definition == null || this.field_13_name_definition.isEmpty()) {
            this.field_13_name_definition = new Stack();
            ptg = this.createNewPtg();
        } else {
            ptg = (Ptg)this.field_13_name_definition.pop();
        }
        short s = 0;
        if (ptg.getClass() == (class$com$fr$third$org$apache$poi$hssf$record$formula$Area3DPtg == null ? (class$com$fr$third$org$apache$poi$hssf$record$formula$Area3DPtg = NameRecord.class$("com.fr.third.org.apache.poi.hssf.record.formula.Area3DPtg")) : class$com$fr$third$org$apache$poi$hssf$record$formula$Area3DPtg)) {
            s = ((Area3DPtg)ptg).getExternSheetIndex();
        } else if (ptg.getClass() == (class$com$fr$third$org$apache$poi$hssf$record$formula$Ref3DPtg == null ? (class$com$fr$third$org$apache$poi$hssf$record$formula$Ref3DPtg = NameRecord.class$("com.fr.third.org.apache.poi.hssf.record.formula.Ref3DPtg")) : class$com$fr$third$org$apache$poi$hssf$record$formula$Ref3DPtg)) {
            s = ((Ref3DPtg)ptg).getExternSheetIndex();
        }
        if (rangeAddress.hasRange()) {
            Ptg ptg2;
            AreaReference[] areaReferenceArray = AreaReference.generateContiguous(string);
            this.setDefinitionTextLength((short)0);
            for (int i = 0; i < areaReferenceArray.length; ++i) {
                ptg2 = new Area3DPtg();
                ((Area3DPtg)ptg2).setExternSheetIndex(s);
                ((Area3DPtg)ptg2).setArea(areaReferenceArray[i].formatAsString());
                this.field_13_name_definition.push(ptg2);
                this.setDefinitionTextLength((short)(this.getDefinitionLength() + ptg2.getSize()));
            }
            if (areaReferenceArray.length > 1) {
                ptg2 = UnionPtg.instance;
                this.field_13_name_definition.push(ptg2);
                this.setDefinitionTextLength((short)(this.getDefinitionLength() + ptg2.getSize()));
            }
        } else {
            Ref3DPtg ref3DPtg = new Ref3DPtg();
            ref3DPtg.setExternSheetIndex(s);
            ref3DPtg.setArea(string);
            this.field_13_name_definition.push(ref3DPtg);
            this.setDefinitionTextLength((short)((Ptg)ref3DPtg).getSize());
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_option_flag = recordInputStream.readShort();
        this.field_2_keyboard_shortcut = recordInputStream.readByte();
        this.field_3_length_name_text = recordInputStream.readByte();
        this.field_4_length_name_definition = recordInputStream.readShort();
        this.field_5_index_to_sheet = recordInputStream.readShort();
        this.field_6_equals_to_index_to_sheet = recordInputStream.readShort();
        this.field_7_length_custom_menu = recordInputStream.readByte();
        this.field_8_length_description_text = recordInputStream.readByte();
        this.field_9_length_help_topic_text = recordInputStream.readByte();
        this.field_10_length_status_bar_text = recordInputStream.readByte();
        this.field_11_compressed_unicode_flag = recordInputStream.readByte();
        if (this.isBuiltInName()) {
            this.field_12_builtIn_name = recordInputStream.readByte();
        } else {
            this.field_12_name_text = this.field_11_compressed_unicode_flag == 1 ? recordInputStream.readUnicodeLEString(this.field_3_length_name_text) : recordInputStream.readCompressedUnicode(this.field_3_length_name_text);
        }
        this.field_13_name_definition = Ptg.createParsedExpressionTokens(this.field_4_length_name_definition, recordInputStream);
        this.field_14_custom_menu_text = recordInputStream.readCompressedUnicode(LittleEndian.ubyteToInt(this.field_7_length_custom_menu));
        this.field_15_description_text = recordInputStream.readCompressedUnicode(LittleEndian.ubyteToInt(this.field_8_length_description_text));
        this.field_16_help_topic_text = recordInputStream.readCompressedUnicode(LittleEndian.ubyteToInt(this.field_9_length_help_topic_text));
        this.field_17_status_bar_text = recordInputStream.readCompressedUnicode(LittleEndian.ubyteToInt(this.field_10_length_status_bar_text));
    }

    public short getSid() {
        return 24;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[NAME]\n");
        stringBuffer.append("    .option flags         = ").append(HexDump.toHex(this.field_1_option_flag)).append("\n");
        stringBuffer.append("    .keyboard shortcut    = ").append(HexDump.toHex(this.field_2_keyboard_shortcut)).append("\n");
        stringBuffer.append("    .length of the name   = ").append(this.field_3_length_name_text).append("\n");
        stringBuffer.append("    .size of the formula data = ").append(this.field_4_length_name_definition).append("\n");
        stringBuffer.append("    .unused                   = ").append(this.field_5_index_to_sheet).append("\n");
        stringBuffer.append("    .index to sheet (1-based, 0=Global)           = ").append(this.field_6_equals_to_index_to_sheet).append("\n");
        stringBuffer.append("    .Length of menu text (character count)        = ").append(this.field_7_length_custom_menu).append("\n");
        stringBuffer.append("    .Length of description text (character count) = ").append(this.field_8_length_description_text).append("\n");
        stringBuffer.append("    .Length of help topic text (character count)  = ").append(this.field_9_length_help_topic_text).append("\n");
        stringBuffer.append("    .Length of status bar text (character count)  = ").append(this.field_10_length_status_bar_text).append("\n");
        stringBuffer.append("    .Name (Unicode flag)  = ").append(this.field_11_compressed_unicode_flag).append("\n");
        stringBuffer.append("    .Name (Unicode text)  = ").append(this.getNameText()).append("\n");
        stringBuffer.append("    .Parts (" + this.field_13_name_definition.size() + "):").append("\n");
        Iterator iterator = this.field_13_name_definition.iterator();
        while (iterator.hasNext()) {
            Ptg ptg = (Ptg)iterator.next();
            stringBuffer.append("       " + ptg.toString()).append("\n");
        }
        stringBuffer.append("    .Menu text (Unicode string without length field)        = ").append(this.field_14_custom_menu_text).append("\n");
        stringBuffer.append("    .Description text (Unicode string without length field) = ").append(this.field_15_description_text).append("\n");
        stringBuffer.append("    .Help topic text (Unicode string without length field)  = ").append(this.field_16_help_topic_text).append("\n");
        stringBuffer.append("    .Status bar text (Unicode string without length field)  = ").append(this.field_17_status_bar_text).append("\n");
        stringBuffer.append("[/NAME]\n");
        return stringBuffer.toString();
    }

    protected String translateBuiltInName(byte by) {
        switch (by) {
            case 10: {
                return "Auto_Activate";
            }
            case 3: {
                return "Auto_Close";
            }
            case 11: {
                return "Auto_Deactivate";
            }
            case 2: {
                return "Auto_Open";
            }
            case 1: {
                return "Consolidate_Area";
            }
            case 5: {
                return "Criteria";
            }
            case 4: {
                return "Database";
            }
            case 9: {
                return "Data_Form";
            }
            case 6: {
                return "Print_Area";
            }
            case 7: {
                return "Print_Titles";
            }
            case 8: {
                return "Recorder";
            }
            case 12: {
                return "Sheet_Title";
            }
        }
        return "Unknown";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

