/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.RkRec;
import com.fr.third.org.apache.poi.hssf.util.RKUtil;
import java.util.ArrayList;

public class MulRKRecord
extends Record {
    public static final short sid = 189;
    private int field_1_row;
    private short field_2_first_col;
    private ArrayList field_3_rks;
    private short field_4_last_col;

    public MulRKRecord() {
    }

    public MulRKRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    public int getRow() {
        return this.field_1_row;
    }

    public short getFirstColumn() {
        return this.field_2_first_col;
    }

    public short getLastColumn() {
        return this.field_4_last_col;
    }

    public int getNumColumns() {
        return this.field_4_last_col - this.field_2_first_col + 1;
    }

    public short getXFAt(int n) {
        return ((RkRec)this.field_3_rks.get((int)n)).xf;
    }

    public double getRKNumberAt(int n) {
        return RKUtil.decodeNumber(((RkRec)this.field_3_rks.get((int)n)).rk);
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_row = recordInputStream.readUShort();
        this.field_2_first_col = recordInputStream.readShort();
        this.field_3_rks = this.parseRKs(recordInputStream);
        this.field_4_last_col = recordInputStream.readShort();
    }

    private ArrayList parseRKs(RecordInputStream recordInputStream) {
        ArrayList<RkRec> arrayList = new ArrayList<RkRec>();
        while (recordInputStream.remaining() - 2 > 0) {
            RkRec rkRec = new RkRec();
            rkRec.xf = recordInputStream.readShort();
            rkRec.rk = recordInputStream.readInt();
            arrayList.add(rkRec);
        }
        return arrayList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[MULRK]\n");
        stringBuffer.append("firstcol  = ").append(Integer.toHexString(this.getFirstColumn())).append("\n");
        stringBuffer.append(" lastcol  = ").append(Integer.toHexString(this.getLastColumn())).append("\n");
        for (int i = 0; i < this.getNumColumns(); ++i) {
            stringBuffer.append("xf").append(i).append("        = ").append(Integer.toHexString(this.getXFAt(i))).append("\n");
            stringBuffer.append("rk").append(i).append("        = ").append(this.getRKNumberAt(i)).append("\n");
        }
        stringBuffer.append("[/MULRK]\n");
        return stringBuffer.toString();
    }

    protected void validateSid(short s) {
        if (s != 189) {
            throw new RecordFormatException("Not a MulRKRecord!");
        }
    }

    public short getSid() {
        return 189;
    }

    public int serialize(int n, byte[] byArray) {
        throw new RecordFormatException("Sorry, you can't serialize a MulRK in this release");
    }
}

