/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;

public class MulBlankRecord
extends Record {
    public static final short sid = 190;
    private int field_1_row;
    private short field_2_first_col;
    private short[] field_3_xfs;
    private short field_4_last_col;

    public MulBlankRecord() {
    }

    public MulBlankRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    public int getRow() {
        return this.field_1_row;
    }

    public short getFirstColumn() {
        return this.field_2_first_col;
    }

    public short getLastColumn() {
        return this.field_4_last_col;
    }

    public int getNumColumns() {
        return this.field_4_last_col - this.field_2_first_col + 1;
    }

    public short getXFAt(int n) {
        return this.field_3_xfs[n];
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_row = recordInputStream.readUShort();
        this.field_2_first_col = recordInputStream.readShort();
        this.field_3_xfs = this.parseXFs(recordInputStream);
        this.field_4_last_col = recordInputStream.readShort();
    }

    private short[] parseXFs(RecordInputStream recordInputStream) {
        short[] sArray = new short[(recordInputStream.remaining() - 2) / 2];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = recordInputStream.readShort();
        }
        return sArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[MULBLANK]\n");
        stringBuffer.append("row  = ").append(Integer.toHexString(this.getRow())).append("\n");
        stringBuffer.append("firstcol  = ").append(Integer.toHexString(this.getFirstColumn())).append("\n");
        stringBuffer.append(" lastcol  = ").append(Integer.toHexString(this.getLastColumn())).append("\n");
        for (int i = 0; i < this.getNumColumns(); ++i) {
            stringBuffer.append("xf").append(i).append("        = ").append(Integer.toHexString(this.getXFAt(i))).append("\n");
        }
        stringBuffer.append("[/MULBLANK]\n");
        return stringBuffer.toString();
    }

    protected void validateSid(short s) {
        if (s != 190) {
            throw new RecordFormatException("Not a MulBlankRecord!");
        }
    }

    public short getSid() {
        return 190;
    }

    public int serialize(int n, byte[] byArray) {
        throw new RecordFormatException("Sorry, you can't serialize a MulBlank in this release");
    }
}

