/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;
import java.util.ArrayList;
import java.util.Iterator;

public class MergeCellsRecord
extends Record {
    public static final short sid = 229;
    private ArrayList field_2_regions;

    public MergeCellsRecord() {
    }

    public MergeCellsRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        int n = recordInputStream.readShort();
        this.field_2_regions = new ArrayList(n + 10);
        for (int i = 0; i < n; ++i) {
            MergedRegion mergedRegion = new MergedRegion(recordInputStream.readShort(), recordInputStream.readShort(), recordInputStream.readShort(), recordInputStream.readShort());
            this.field_2_regions.add(mergedRegion);
        }
    }

    public short getNumAreas() {
        if (this.field_2_regions == null) {
            return 0;
        }
        return (short)this.field_2_regions.size();
    }

    public void setNumAreas(short s) {
    }

    public int addArea(int n, short s, int n2, short s2) {
        if (this.field_2_regions == null) {
            this.field_2_regions = new ArrayList(10);
        }
        MergedRegion mergedRegion = new MergedRegion(n, n2, s, s2);
        this.field_2_regions.add(mergedRegion);
        return this.field_2_regions.size() - 1;
    }

    public void removeAreaAt(int n) {
        this.field_2_regions.remove(n);
    }

    public MergedRegion getAreaAt(int n) {
        return (MergedRegion)this.field_2_regions.get(n);
    }

    public int getRecordSize() {
        int n = 6 + 8 * this.field_2_regions.size();
        return n;
    }

    public short getSid() {
        return 229;
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = this.getRecordSize();
        int n3 = 6;
        LittleEndian.putShort(byArray, n + 0, (short)229);
        LittleEndian.putShort(byArray, n + 2, (short)(n2 - 4));
        LittleEndian.putShort(byArray, n + 4, this.getNumAreas());
        for (int i = 0; i < this.getNumAreas(); ++i) {
            MergedRegion mergedRegion = this.getAreaAt(i);
            LittleEndian.putShort(byArray, n + n3, (short)mergedRegion.row_from);
            LittleEndian.putShort(byArray, n + (n3 += 2), (short)mergedRegion.row_to);
            LittleEndian.putShort(byArray, n + (n3 += 2), mergedRegion.col_from);
            LittleEndian.putShort(byArray, n + (n3 += 2), mergedRegion.col_to);
            n3 += 2;
        }
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[MERGEDCELLS]").append("\n");
        stringBuffer.append("     .sid        =").append(229).append("\n");
        stringBuffer.append("     .numregions =").append(this.getNumAreas()).append("\n");
        for (int i = 0; i < this.getNumAreas(); ++i) {
            MergedRegion mergedRegion = (MergedRegion)this.field_2_regions.get(i);
            stringBuffer.append("     .rowfrom    =").append(mergedRegion.row_from).append("\n");
            stringBuffer.append("     .colfrom    =").append(mergedRegion.col_from).append("\n");
            stringBuffer.append("     .rowto      =").append(mergedRegion.row_to).append("\n");
            stringBuffer.append("     .colto      =").append(mergedRegion.col_to).append("\n");
        }
        stringBuffer.append("[MERGEDCELLS]").append("\n");
        return stringBuffer.toString();
    }

    protected void validateSid(short s) {
        if (s != 229) {
            throw new RecordFormatException("NOT A MERGEDCELLS RECORD!! " + s);
        }
    }

    public Object clone() {
        MergeCellsRecord mergeCellsRecord = new MergeCellsRecord();
        mergeCellsRecord.field_2_regions = new ArrayList();
        Iterator iterator = this.field_2_regions.iterator();
        while (iterator.hasNext()) {
            MergedRegion mergedRegion = (MergedRegion)iterator.next();
            mergeCellsRecord.addArea(mergedRegion.row_from, mergedRegion.col_from, mergedRegion.row_to, mergedRegion.col_to);
        }
        return mergeCellsRecord;
    }

    public class MergedRegion {
        public int row_from;
        public int row_to;
        public short col_from;
        public short col_to;

        public MergedRegion(int n, int n2, short s, short s2) {
            this.row_from = n;
            this.row_to = n2;
            this.col_from = s;
            this.col_to = s2;
        }
    }
}

