/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class MMSRecord
extends Record {
    public static final short sid = 193;
    private byte field_1_addMenuCount;
    private byte field_2_delMenuCount;

    public MMSRecord() {
    }

    public MMSRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 193) {
            throw new RecordFormatException("NOT A MMS RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_addMenuCount = recordInputStream.readByte();
        this.field_2_delMenuCount = recordInputStream.readByte();
    }

    public void setAddMenuCount(byte by) {
        this.field_1_addMenuCount = by;
    }

    public void setDelMenuCount(byte by) {
        this.field_2_delMenuCount = by;
    }

    public byte getAddMenuCount() {
        return this.field_1_addMenuCount;
    }

    public byte getDelMenuCount() {
        return this.field_2_delMenuCount;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[MMS]\n");
        stringBuffer.append("    .addMenu        = ").append(Integer.toHexString(this.getAddMenuCount())).append("\n");
        stringBuffer.append("    .delMenu        = ").append(Integer.toHexString(this.getDelMenuCount())).append("\n");
        stringBuffer.append("[/MMS]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)193);
        LittleEndian.putShort(byArray, 2 + n, (short)2);
        byArray[4 + n] = this.getAddMenuCount();
        byArray[5 + n] = this.getDelMenuCount();
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 193;
    }
}

