/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.LinkedDataFormulaField;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class LinkedDataRecord
extends Record {
    public static final short sid = 4177;
    private byte field_1_linkType;
    public static final byte LINK_TYPE_TITLE_OR_TEXT = 0;
    public static final byte LINK_TYPE_VALUES = 1;
    public static final byte LINK_TYPE_CATEGORIES = 2;
    private byte field_2_referenceType;
    public static final byte REFERENCE_TYPE_DEFAULT_CATEGORIES = 0;
    public static final byte REFERENCE_TYPE_DIRECT = 1;
    public static final byte REFERENCE_TYPE_WORKSHEET = 2;
    public static final byte REFERENCE_TYPE_NOT_USED = 3;
    public static final byte REFERENCE_TYPE_ERROR_REPORTED = 4;
    private short field_3_options;
    private BitField customNumberFormat = BitFieldFactory.getInstance(1);
    private short field_4_indexNumberFmtRecord;
    private LinkedDataFormulaField field_5_formulaOfLink;

    public LinkedDataRecord() {
    }

    public LinkedDataRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 4177) {
            throw new RecordFormatException("Not a LinkedData record");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_linkType = recordInputStream.readByte();
        this.field_2_referenceType = recordInputStream.readByte();
        this.field_3_options = recordInputStream.readShort();
        this.field_4_indexNumberFmtRecord = recordInputStream.readShort();
        this.field_5_formulaOfLink = new LinkedDataFormulaField();
        this.field_5_formulaOfLink.fillField(recordInputStream);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[AI]\n");
        stringBuffer.append("    .linkType             = ").append("0x").append(HexDump.toHex(this.getLinkType())).append(" (").append(this.getLinkType()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .referenceType        = ").append("0x").append(HexDump.toHex(this.getReferenceType())).append(" (").append(this.getReferenceType()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .options              = ").append("0x").append(HexDump.toHex(this.getOptions())).append(" (").append(this.getOptions()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("         .customNumberFormat       = ").append(this.isCustomNumberFormat()).append('\n');
        stringBuffer.append("    .indexNumberFmtRecord = ").append("0x").append(HexDump.toHex(this.getIndexNumberFmtRecord())).append(" (").append(this.getIndexNumberFmtRecord()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .formulaOfLink        = ").append(" (").append(this.getFormulaOfLink()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("[/AI]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = 0;
        LittleEndian.putShort(byArray, 0 + n, (short)4177);
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        byArray[4 + n + n2] = this.field_1_linkType;
        byArray[5 + n + n2] = this.field_2_referenceType;
        LittleEndian.putShort(byArray, 6 + n + n2, this.field_3_options);
        LittleEndian.putShort(byArray, 8 + n + n2, this.field_4_indexNumberFmtRecord);
        n2 += this.field_5_formulaOfLink.serializeField(n2 + 10 + n, byArray);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 10 + this.field_5_formulaOfLink.getSize();
    }

    public short getSid() {
        return 4177;
    }

    public Object clone() {
        LinkedDataRecord linkedDataRecord = new LinkedDataRecord();
        linkedDataRecord.field_1_linkType = this.field_1_linkType;
        linkedDataRecord.field_2_referenceType = this.field_2_referenceType;
        linkedDataRecord.field_3_options = this.field_3_options;
        linkedDataRecord.field_4_indexNumberFmtRecord = this.field_4_indexNumberFmtRecord;
        linkedDataRecord.field_5_formulaOfLink = (LinkedDataFormulaField)this.field_5_formulaOfLink.clone();
        return linkedDataRecord;
    }

    public byte getLinkType() {
        return this.field_1_linkType;
    }

    public void setLinkType(byte by) {
        this.field_1_linkType = by;
    }

    public byte getReferenceType() {
        return this.field_2_referenceType;
    }

    public void setReferenceType(byte by) {
        this.field_2_referenceType = by;
    }

    public short getOptions() {
        return this.field_3_options;
    }

    public void setOptions(short s) {
        this.field_3_options = s;
    }

    public short getIndexNumberFmtRecord() {
        return this.field_4_indexNumberFmtRecord;
    }

    public void setIndexNumberFmtRecord(short s) {
        this.field_4_indexNumberFmtRecord = s;
    }

    public LinkedDataFormulaField getFormulaOfLink() {
        return this.field_5_formulaOfLink;
    }

    public void setFormulaOfLink(LinkedDataFormulaField linkedDataFormulaField) {
        this.field_5_formulaOfLink = linkedDataFormulaField;
    }

    public void setCustomNumberFormat(boolean bl) {
        this.field_3_options = this.customNumberFormat.setShortBoolean(this.field_3_options, bl);
    }

    public boolean isCustomNumberFormat() {
        return this.customNumberFormat.isSet(this.field_3_options);
    }
}

