/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.CustomField;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.formula.Ptg;
import com.fr.third.org.apache.poi.util.LittleEndian;
import java.util.Iterator;
import java.util.Stack;

public class LinkedDataFormulaField
implements CustomField {
    Stack formulaTokens = new Stack();

    public int getSize() {
        int n = 0;
        Iterator iterator = this.formulaTokens.iterator();
        while (iterator.hasNext()) {
            Ptg ptg = (Ptg)iterator.next();
            n += ptg.getSize();
        }
        return n + 2;
    }

    public int fillField(RecordInputStream recordInputStream) {
        short s = recordInputStream.readShort();
        this.formulaTokens = Ptg.createParsedExpressionTokens(s, recordInputStream);
        return s + 2;
    }

    public void toString(StringBuffer stringBuffer) {
        for (int i = 0; i < this.formulaTokens.size(); ++i) {
            stringBuffer.append("Formula ").append(i).append("=").append(this.formulaTokens.get(i).toString()).append("\n").append(((Ptg)this.formulaTokens.get(i)).toDebugString()).append("\n");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toString(stringBuffer);
        return stringBuffer.toString();
    }

    public int serializeField(int n, byte[] byArray) {
        int n2 = this.getSize();
        LittleEndian.putShort(byArray, n, (short)(n2 - 2));
        int n3 = n + 2;
        n3 += Ptg.serializePtgStack(this.formulaTokens, byArray, n3);
        return n2;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void setFormulaTokens(Stack stack) {
        this.formulaTokens = (Stack)stack.clone();
    }

    public Stack getFormulaTokens() {
        return (Stack)this.formulaTokens.clone();
    }
}

