/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class LegendRecord
extends Record {
    public static final short sid = 4117;
    private int field_1_xAxisUpperLeft;
    private int field_2_yAxisUpperLeft;
    private int field_3_xSize;
    private int field_4_ySize;
    private byte field_5_type;
    public static final byte TYPE_BOTTOM = 0;
    public static final byte TYPE_CORNER = 1;
    public static final byte TYPE_TOP = 2;
    public static final byte TYPE_RIGHT = 3;
    public static final byte TYPE_LEFT = 4;
    public static final byte TYPE_UNDOCKED = 7;
    private byte field_6_spacing;
    public static final byte SPACING_CLOSE = 0;
    public static final byte SPACING_MEDIUM = 1;
    public static final byte SPACING_OPEN = 2;
    private short field_7_options;
    private BitField autoPosition = BitFieldFactory.getInstance(1);
    private BitField autoSeries = BitFieldFactory.getInstance(2);
    private BitField autoXPositioning = BitFieldFactory.getInstance(4);
    private BitField autoYPositioning = BitFieldFactory.getInstance(8);
    private BitField vertical = BitFieldFactory.getInstance(16);
    private BitField dataTable = BitFieldFactory.getInstance(32);

    public LegendRecord() {
    }

    public LegendRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 4117) {
            throw new RecordFormatException("Not a Legend record");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_xAxisUpperLeft = recordInputStream.readInt();
        this.field_2_yAxisUpperLeft = recordInputStream.readInt();
        this.field_3_xSize = recordInputStream.readInt();
        this.field_4_ySize = recordInputStream.readInt();
        this.field_5_type = recordInputStream.readByte();
        this.field_6_spacing = recordInputStream.readByte();
        this.field_7_options = recordInputStream.readShort();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[LEGEND]\n");
        stringBuffer.append("    .xAxisUpperLeft       = ").append("0x").append(HexDump.toHex(this.getXAxisUpperLeft())).append(" (").append(this.getXAxisUpperLeft()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .yAxisUpperLeft       = ").append("0x").append(HexDump.toHex(this.getYAxisUpperLeft())).append(" (").append(this.getYAxisUpperLeft()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .xSize                = ").append("0x").append(HexDump.toHex(this.getXSize())).append(" (").append(this.getXSize()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .ySize                = ").append("0x").append(HexDump.toHex(this.getYSize())).append(" (").append(this.getYSize()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .type                 = ").append("0x").append(HexDump.toHex(this.getType())).append(" (").append(this.getType()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .spacing              = ").append("0x").append(HexDump.toHex(this.getSpacing())).append(" (").append(this.getSpacing()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .options              = ").append("0x").append(HexDump.toHex(this.getOptions())).append(" (").append(this.getOptions()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("         .autoPosition             = ").append(this.isAutoPosition()).append('\n');
        stringBuffer.append("         .autoSeries               = ").append(this.isAutoSeries()).append('\n');
        stringBuffer.append("         .autoXPositioning         = ").append(this.isAutoXPositioning()).append('\n');
        stringBuffer.append("         .autoYPositioning         = ").append(this.isAutoYPositioning()).append('\n');
        stringBuffer.append("         .vertical                 = ").append(this.isVertical()).append('\n');
        stringBuffer.append("         .dataTable                = ").append(this.isDataTable()).append('\n');
        stringBuffer.append("[/LEGEND]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = 0;
        LittleEndian.putShort(byArray, 0 + n, (short)4117);
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        LittleEndian.putInt(byArray, 4 + n + n2, this.field_1_xAxisUpperLeft);
        LittleEndian.putInt(byArray, 8 + n + n2, this.field_2_yAxisUpperLeft);
        LittleEndian.putInt(byArray, 12 + n + n2, this.field_3_xSize);
        LittleEndian.putInt(byArray, 16 + n + n2, this.field_4_ySize);
        byArray[20 + n + n2] = this.field_5_type;
        byArray[21 + n + n2] = this.field_6_spacing;
        LittleEndian.putShort(byArray, 22 + n + n2, this.field_7_options);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 24;
    }

    public short getSid() {
        return 4117;
    }

    public Object clone() {
        LegendRecord legendRecord = new LegendRecord();
        legendRecord.field_1_xAxisUpperLeft = this.field_1_xAxisUpperLeft;
        legendRecord.field_2_yAxisUpperLeft = this.field_2_yAxisUpperLeft;
        legendRecord.field_3_xSize = this.field_3_xSize;
        legendRecord.field_4_ySize = this.field_4_ySize;
        legendRecord.field_5_type = this.field_5_type;
        legendRecord.field_6_spacing = this.field_6_spacing;
        legendRecord.field_7_options = this.field_7_options;
        return legendRecord;
    }

    public int getXAxisUpperLeft() {
        return this.field_1_xAxisUpperLeft;
    }

    public void setXAxisUpperLeft(int n) {
        this.field_1_xAxisUpperLeft = n;
    }

    public int getYAxisUpperLeft() {
        return this.field_2_yAxisUpperLeft;
    }

    public void setYAxisUpperLeft(int n) {
        this.field_2_yAxisUpperLeft = n;
    }

    public int getXSize() {
        return this.field_3_xSize;
    }

    public void setXSize(int n) {
        this.field_3_xSize = n;
    }

    public int getYSize() {
        return this.field_4_ySize;
    }

    public void setYSize(int n) {
        this.field_4_ySize = n;
    }

    public byte getType() {
        return this.field_5_type;
    }

    public void setType(byte by) {
        this.field_5_type = by;
    }

    public byte getSpacing() {
        return this.field_6_spacing;
    }

    public void setSpacing(byte by) {
        this.field_6_spacing = by;
    }

    public short getOptions() {
        return this.field_7_options;
    }

    public void setOptions(short s) {
        this.field_7_options = s;
    }

    public void setAutoPosition(boolean bl) {
        this.field_7_options = this.autoPosition.setShortBoolean(this.field_7_options, bl);
    }

    public boolean isAutoPosition() {
        return this.autoPosition.isSet(this.field_7_options);
    }

    public void setAutoSeries(boolean bl) {
        this.field_7_options = this.autoSeries.setShortBoolean(this.field_7_options, bl);
    }

    public boolean isAutoSeries() {
        return this.autoSeries.isSet(this.field_7_options);
    }

    public void setAutoXPositioning(boolean bl) {
        this.field_7_options = this.autoXPositioning.setShortBoolean(this.field_7_options, bl);
    }

    public boolean isAutoXPositioning() {
        return this.autoXPositioning.isSet(this.field_7_options);
    }

    public void setAutoYPositioning(boolean bl) {
        this.field_7_options = this.autoYPositioning.setShortBoolean(this.field_7_options, bl);
    }

    public boolean isAutoYPositioning() {
        return this.autoYPositioning.isSet(this.field_7_options);
    }

    public void setVertical(boolean bl) {
        this.field_7_options = this.vertical.setShortBoolean(this.field_7_options, bl);
    }

    public boolean isVertical() {
        return this.vertical.isSet(this.field_7_options);
    }

    public void setDataTable(boolean bl) {
        this.field_7_options = this.dataTable.setShortBoolean(this.field_7_options, bl);
    }

    public boolean isDataTable() {
        return this.dataTable.isSet(this.field_7_options);
    }
}

