/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.CellValueRecordInterface;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class LabelSSTRecord
extends Record
implements CellValueRecordInterface,
Comparable {
    public static final short sid = 253;
    private int field_1_row;
    private short field_2_column;
    private short field_3_xf_index;
    private int field_4_sst_index;

    public LabelSSTRecord() {
    }

    public LabelSSTRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 253) {
            throw new RecordFormatException("NOT A valid LabelSST RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_row = recordInputStream.readUShort();
        this.field_2_column = recordInputStream.readShort();
        this.field_3_xf_index = recordInputStream.readShort();
        this.field_4_sst_index = recordInputStream.readInt();
    }

    public void setRow(int n) {
        this.field_1_row = n;
    }

    public void setColumn(short s) {
        this.field_2_column = s;
    }

    public void setXFIndex(short s) {
        this.field_3_xf_index = s;
    }

    public void setSSTIndex(int n) {
        this.field_4_sst_index = n;
    }

    public int getRow() {
        return this.field_1_row;
    }

    public short getColumn() {
        return this.field_2_column;
    }

    public short getXFIndex() {
        return this.field_3_xf_index;
    }

    public int getSSTIndex() {
        return this.field_4_sst_index;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[LABELSST]\n");
        stringBuffer.append("    .row            = ").append(Integer.toHexString(this.getRow())).append("\n");
        stringBuffer.append("    .column         = ").append(Integer.toHexString(this.getColumn())).append("\n");
        stringBuffer.append("    .xfindex        = ").append(Integer.toHexString(this.getXFIndex())).append("\n");
        stringBuffer.append("    .sstindex       = ").append(Integer.toHexString(this.getSSTIndex())).append("\n");
        stringBuffer.append("[/LABELSST]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)253);
        LittleEndian.putShort(byArray, 2 + n, (short)10);
        LittleEndian.putShort(byArray, 4 + n, (short)this.getRow());
        LittleEndian.putShort(byArray, 6 + n, this.getColumn());
        LittleEndian.putShort(byArray, 8 + n, this.getXFIndex());
        LittleEndian.putInt(byArray, 10 + n, this.getSSTIndex());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 14;
    }

    public short getSid() {
        return 253;
    }

    public boolean isBefore(CellValueRecordInterface cellValueRecordInterface) {
        if (this.getRow() > cellValueRecordInterface.getRow()) {
            return false;
        }
        if (this.getRow() == cellValueRecordInterface.getRow() && this.getColumn() > cellValueRecordInterface.getColumn()) {
            return false;
        }
        return this.getRow() != cellValueRecordInterface.getRow() || this.getColumn() != cellValueRecordInterface.getColumn();
    }

    public boolean isAfter(CellValueRecordInterface cellValueRecordInterface) {
        if (this.getRow() < cellValueRecordInterface.getRow()) {
            return false;
        }
        if (this.getRow() == cellValueRecordInterface.getRow() && this.getColumn() < cellValueRecordInterface.getColumn()) {
            return false;
        }
        return this.getRow() != cellValueRecordInterface.getRow() || this.getColumn() != cellValueRecordInterface.getColumn();
    }

    public boolean isEqual(CellValueRecordInterface cellValueRecordInterface) {
        return this.getRow() == cellValueRecordInterface.getRow() && this.getColumn() == cellValueRecordInterface.getColumn();
    }

    public boolean isInValueSection() {
        return true;
    }

    public boolean isValue() {
        return true;
    }

    public int compareTo(Object object) {
        CellValueRecordInterface cellValueRecordInterface = (CellValueRecordInterface)object;
        if (this.getRow() == cellValueRecordInterface.getRow() && this.getColumn() == cellValueRecordInterface.getColumn()) {
            return 0;
        }
        if (this.getRow() < cellValueRecordInterface.getRow()) {
            return -1;
        }
        if (this.getRow() > cellValueRecordInterface.getRow()) {
            return 1;
        }
        if (this.getColumn() < cellValueRecordInterface.getColumn()) {
            return -1;
        }
        if (this.getColumn() > cellValueRecordInterface.getColumn()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CellValueRecordInterface)) {
            return false;
        }
        CellValueRecordInterface cellValueRecordInterface = (CellValueRecordInterface)object;
        return this.getRow() == cellValueRecordInterface.getRow() && this.getColumn() == cellValueRecordInterface.getColumn();
    }

    public Object clone() {
        LabelSSTRecord labelSSTRecord = new LabelSSTRecord();
        labelSSTRecord.field_1_row = this.field_1_row;
        labelSSTRecord.field_2_column = this.field_2_column;
        labelSSTRecord.field_3_xf_index = this.field_3_xf_index;
        labelSSTRecord.field_4_sst_index = this.field_4_sst_index;
        return labelSSTRecord;
    }
}

