/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class IterationRecord
extends Record {
    public static final short sid = 17;
    private short field_1_iteration;

    public IterationRecord() {
    }

    public IterationRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 17) {
            throw new RecordFormatException("NOT An ITERATION RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_iteration = recordInputStream.readShort();
    }

    public void setIteration(boolean bl) {
        this.field_1_iteration = bl ? (short)1 : 0;
    }

    public boolean getIteration() {
        return this.field_1_iteration == 1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ITERATION]\n");
        stringBuffer.append("    .iteration      = ").append(this.getIteration()).append("\n");
        stringBuffer.append("[/ITERATION]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)17);
        LittleEndian.putShort(byArray, 2 + n, (short)2);
        LittleEndian.putShort(byArray, 4 + n, this.field_1_iteration);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 17;
    }

    public Object clone() {
        IterationRecord iterationRecord = new IterationRecord();
        iterationRecord.field_1_iteration = this.field_1_iteration;
        return iterationRecord;
    }
}

