/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.IntList;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class IndexRecord
extends Record {
    public static final short sid = 523;
    public static final int DBCELL_CAPACITY = 30;
    public int field_1_zero;
    public int field_2_first_row;
    public int field_3_last_row_add1;
    public int field_4_zero;
    public IntList field_5_dbcells;

    public IndexRecord() {
    }

    public IndexRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 523) {
            throw new RecordFormatException("NOT An Index RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_5_dbcells = new IntList(30);
        this.field_1_zero = recordInputStream.readInt();
        this.field_2_first_row = recordInputStream.readInt();
        this.field_3_last_row_add1 = recordInputStream.readInt();
        this.field_4_zero = recordInputStream.readInt();
        while (recordInputStream.remaining() > 0) {
            this.field_5_dbcells.add(recordInputStream.readInt());
        }
    }

    public void setFirstRow(int n) {
        this.field_2_first_row = n;
    }

    public void setLastRowAdd1(int n) {
        this.field_3_last_row_add1 = n;
    }

    public void addDbcell(int n) {
        if (this.field_5_dbcells == null) {
            this.field_5_dbcells = new IntList();
        }
        this.field_5_dbcells.add(n);
    }

    public void setDbcell(int n, int n2) {
        this.field_5_dbcells.set(n, n2);
    }

    public int getFirstRow() {
        return this.field_2_first_row;
    }

    public int getLastRowAdd1() {
        return this.field_3_last_row_add1;
    }

    public int getNumDbcells() {
        if (this.field_5_dbcells == null) {
            return 0;
        }
        return this.field_5_dbcells.size();
    }

    public int getDbcellAt(int n) {
        return this.field_5_dbcells.get(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[INDEX]\n");
        stringBuffer.append("    .firstrow       = ").append(Integer.toHexString(this.getFirstRow())).append("\n");
        stringBuffer.append("    .lastrowadd1    = ").append(Integer.toHexString(this.getLastRowAdd1())).append("\n");
        for (int i = 0; i < this.getNumDbcells(); ++i) {
            stringBuffer.append("    .dbcell_" + i + "       = ").append(Integer.toHexString(this.getDbcellAt(i))).append("\n");
        }
        stringBuffer.append("[/INDEX]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)523);
        LittleEndian.putShort(byArray, 2 + n, (short)(16 + this.getNumDbcells() * 4));
        LittleEndian.putInt(byArray, 4 + n, 0);
        LittleEndian.putInt(byArray, 8 + n, this.getFirstRow());
        LittleEndian.putInt(byArray, 12 + n, this.getLastRowAdd1());
        LittleEndian.putInt(byArray, 16 + n, 0);
        for (int i = 0; i < this.getNumDbcells(); ++i) {
            LittleEndian.putInt(byArray, i * 4 + 20 + n, this.getDbcellAt(i));
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 20 + this.getNumDbcells() * 4;
    }

    public static int getRecordSizeForBlockCount(int n) {
        return 20 + 4 * n;
    }

    public short getSid() {
        return 523;
    }

    public Object clone() {
        IndexRecord indexRecord = new IndexRecord();
        indexRecord.field_1_zero = this.field_1_zero;
        indexRecord.field_2_first_row = this.field_2_first_row;
        indexRecord.field_3_last_row_add1 = this.field_3_last_row_add1;
        indexRecord.field_4_zero = this.field_4_zero;
        indexRecord.field_5_dbcells = new IntList();
        indexRecord.field_5_dbcells.addAll(this.field_5_dbcells);
        return indexRecord;
    }
}

