/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;
import com.fr.third.org.apache.poi.util.StringUtil;
import java.io.IOException;
import java.util.Arrays;

public class HyperlinkRecord
extends Record {
    protected static final int HLINK_URL = 1;
    protected static final int HLINK_ABS = 2;
    protected static final int HLINK_LABEL = 20;
    protected static final int HLINK_PLACE = 8;
    protected static final byte[] STD_MONIKER = new byte[]{-48, -55, -22, 121, -7, -70, -50, 17, -116, -126, 0, -86, 0, 75, -87, 11};
    protected static final byte[] URL_MONIKER = new byte[]{-32, -55, -22, 121, -7, -70, -50, 17, -116, -126, 0, -86, 0, 75, -87, 11};
    protected static final byte[] FILE_MONIKER = new byte[]{3, 3, 0, 0, 0, 0, 0, 0, -64, 0, 0, 0, 0, 0, 0, 70};
    protected static final byte[] URL_TAIL = new byte[]{121, 88, -127, -12, 59, 29, 127, 72, -81, 44, -126, 93, -60, -123, 39, 99, 0, 0, 0, 0, -91, -85, 0, 0};
    protected static final byte[] FILE_TAIL = new byte[]{-1, -1, -83, -34, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final short sid = 440;
    private int rwFirst;
    private int rwLast;
    private short colFirst;
    private short colLast;
    private byte[] guid;
    private int label_opts;
    private short file_opts;
    private int link_opts;
    private String label;
    private byte[] moniker;
    private String address;
    private byte[] tail;

    public HyperlinkRecord() {
    }

    public HyperlinkRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    public short getFirstColumn() {
        return this.colFirst;
    }

    public void setFirstColumn(short s) {
        this.colFirst = s;
    }

    public short getLastColumn() {
        return this.colLast;
    }

    public void setLastColumn(short s) {
        this.colLast = s;
    }

    public int getFirstRow() {
        return this.rwFirst;
    }

    public void setFirstRow(int n) {
        this.rwFirst = n;
    }

    public int getLastRow() {
        return this.rwLast;
    }

    public void setLastRow(int n) {
        this.rwLast = n;
    }

    public byte[] getGuid() {
        return this.guid;
    }

    public byte[] getMoniker() {
        return this.moniker;
    }

    public String getLabel() {
        int n = this.label.indexOf(0);
        return n == -1 ? this.label : this.label.substring(0, n);
    }

    public void setLabel(String string) {
        this.label = string + '\u0000';
    }

    public String getAddress() {
        int n = this.address.indexOf(0);
        return n == -1 ? this.address : this.address.substring(0, n);
    }

    public void setAddress(String string) {
        this.address = string + '\u0000';
    }

    public int getLinkOptions() {
        return this.link_opts;
    }

    public int getLabelOptions() {
        return this.label_opts;
    }

    public int getFileOptions() {
        return this.file_opts;
    }

    public byte[] getTail() {
        return this.tail;
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        try {
            int n;
            this.rwFirst = recordInputStream.readShort();
            this.rwLast = recordInputStream.readUShort();
            this.colFirst = recordInputStream.readShort();
            this.colLast = recordInputStream.readShort();
            this.guid = new byte[16];
            recordInputStream.read(this.guid);
            this.label_opts = recordInputStream.readInt();
            this.link_opts = recordInputStream.readInt();
            if ((this.link_opts & 0x14) != 0) {
                n = recordInputStream.readInt();
                this.label = recordInputStream.readUnicodeLEString(n);
            }
            if ((this.link_opts & 1) != 0) {
                this.moniker = new byte[16];
                recordInputStream.read(this.moniker);
                if (Arrays.equals(URL_MONIKER, this.moniker)) {
                    n = recordInputStream.readInt();
                    this.address = recordInputStream.readUnicodeLEString(n / 2);
                    this.tail = recordInputStream.readRemainder();
                } else if (Arrays.equals(FILE_MONIKER, this.moniker)) {
                    this.file_opts = recordInputStream.readShort();
                    n = recordInputStream.readInt();
                    byte[] byArray = new byte[n];
                    recordInputStream.read(byArray);
                    this.address = new String(byArray);
                    this.tail = recordInputStream.readRemainder();
                }
            } else if ((this.link_opts & 8) != 0) {
                n = recordInputStream.readInt();
                this.address = recordInputStream.readUnicodeLEString(n);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public short getSid() {
        return 440;
    }

    protected void validateSid(short s) {
        if (s != 440) {
            throw new RecordFormatException("NOT A HYPERLINKRECORD!");
        }
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = n;
        LittleEndian.putShort(byArray, n2, (short)440);
        LittleEndian.putShort(byArray, n2 += 2, (short)(this.getRecordSize() - 4));
        LittleEndian.putUShort(byArray, n2 += 2, this.rwFirst);
        LittleEndian.putUShort(byArray, n2 += 2, this.rwLast);
        LittleEndian.putShort(byArray, n2 += 2, this.colFirst);
        LittleEndian.putShort(byArray, n2 += 2, this.colLast);
        System.arraycopy(this.guid, 0, byArray, n2 += 2, this.guid.length);
        LittleEndian.putInt(byArray, n2 += this.guid.length, this.label_opts);
        LittleEndian.putInt(byArray, n2 += 4, this.link_opts);
        n2 += 4;
        if ((this.link_opts & 0x14) != 0) {
            LittleEndian.putInt(byArray, n2, this.label.length());
            StringUtil.putUnicodeLE(this.label, byArray, n2 += 4);
            n2 += this.label.length() * 2;
        }
        if ((this.link_opts & 1) != 0) {
            System.arraycopy(this.moniker, 0, byArray, n2, this.moniker.length);
            n2 += this.moniker.length;
            if (Arrays.equals(URL_MONIKER, this.moniker)) {
                LittleEndian.putInt(byArray, n2, this.address.length() * 2 + this.tail.length);
                StringUtil.putUnicodeLE(this.address, byArray, n2 += 4);
                n2 += this.address.length() * 2;
                if (this.tail.length > 0) {
                    System.arraycopy(this.tail, 0, byArray, n2, this.tail.length);
                    n2 += this.tail.length;
                }
            } else if (Arrays.equals(FILE_MONIKER, this.moniker)) {
                LittleEndian.putShort(byArray, n2, this.file_opts);
                LittleEndian.putInt(byArray, n2 += 2, this.address.length());
                byte[] byArray2 = this.address.getBytes();
                System.arraycopy(byArray2, 0, byArray, n2 += 4, byArray2.length);
                n2 += byArray2.length;
                if (this.tail.length > 0) {
                    System.arraycopy(this.tail, 0, byArray, n2, this.tail.length);
                    n2 += this.tail.length;
                }
            }
        } else if ((this.link_opts & 8) != 0) {
            LittleEndian.putInt(byArray, n2, this.address.length());
            StringUtil.putUnicodeLE(this.address, byArray, n2 += 4);
            n2 += this.address.length() * 2;
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        int n = 4;
        n += 8;
        n += this.guid.length;
        n += 4;
        n += 4;
        if ((this.link_opts & 0x14) != 0) {
            n += 4;
            n += this.label.length() * 2;
        }
        if ((this.link_opts & 1) != 0) {
            n += this.moniker.length;
            if (Arrays.equals(URL_MONIKER, this.moniker)) {
                n += 4;
                n += this.address.length() * 2;
                n += this.tail.length;
            } else if (Arrays.equals(FILE_MONIKER, this.moniker)) {
                n += 2;
                n += 4;
                n += this.address.length();
                n += this.tail.length;
            }
        } else if ((this.link_opts & 8) != 0) {
            n += 4;
            n += this.address.length() * 2;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[HYPERLINK RECORD]\n");
        stringBuffer.append("    .rwFirst            = ").append(Integer.toHexString(this.getFirstRow())).append("\n");
        stringBuffer.append("    .rwLast         = ").append(Integer.toHexString(this.getLastRow())).append("\n");
        stringBuffer.append("    .colFirst            = ").append(Integer.toHexString(this.getFirstColumn())).append("\n");
        stringBuffer.append("    .colLast         = ").append(Integer.toHexString(this.getLastColumn())).append("\n");
        stringBuffer.append("    .guid        = ").append(HexDump.toHex(this.guid)).append("\n");
        stringBuffer.append("    .label_opts          = ").append(this.label_opts).append("\n");
        stringBuffer.append("    .label          = ").append(this.getLabel()).append("\n");
        if ((this.link_opts & 1) != 0) {
            stringBuffer.append("    .moniker          = ").append(HexDump.toHex(this.moniker)).append("\n");
        }
        stringBuffer.append("    .address            = ").append(this.getAddress()).append("\n");
        stringBuffer.append("[/HYPERLINK RECORD]\n");
        return stringBuffer.toString();
    }

    public void newUrlLink() {
        this.rwFirst = 0;
        this.rwLast = 0;
        this.colFirst = 0;
        this.colLast = 0;
        this.guid = STD_MONIKER;
        this.label_opts = 2;
        this.link_opts = 23;
        this.label = "\u0000";
        this.moniker = URL_MONIKER;
        this.address = "\u0000";
        this.tail = URL_TAIL;
    }

    public void newFileLink() {
        this.rwFirst = 0;
        this.rwLast = 0;
        this.colFirst = 0;
        this.colLast = 0;
        this.guid = STD_MONIKER;
        this.label_opts = 2;
        this.link_opts = 21;
        this.file_opts = 0;
        this.label = "\u0000";
        this.moniker = FILE_MONIKER;
        this.address = "\u0000";
        this.tail = FILE_TAIL;
    }

    public void newDocumentLink() {
        this.rwFirst = 0;
        this.rwLast = 0;
        this.colFirst = 0;
        this.colLast = 0;
        this.guid = STD_MONIKER;
        this.label_opts = 2;
        this.link_opts = 28;
        this.label = "\u0000";
        this.moniker = FILE_MONIKER;
        this.address = "\u0000";
        this.tail = new byte[0];
    }

    public Object clone() {
        HyperlinkRecord hyperlinkRecord = new HyperlinkRecord();
        hyperlinkRecord.rwFirst = this.rwFirst;
        hyperlinkRecord.rwLast = this.rwLast;
        hyperlinkRecord.colFirst = this.colFirst;
        hyperlinkRecord.colLast = this.colLast;
        hyperlinkRecord.guid = this.guid;
        hyperlinkRecord.label_opts = this.label_opts;
        hyperlinkRecord.link_opts = this.link_opts;
        hyperlinkRecord.file_opts = this.file_opts;
        hyperlinkRecord.label = this.label;
        hyperlinkRecord.address = this.address;
        hyperlinkRecord.moniker = this.moniker;
        hyperlinkRecord.tail = this.tail;
        return hyperlinkRecord;
    }
}

