/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;
import com.fr.third.org.apache.poi.util.StringUtil;

public class HeaderRecord
extends Record {
    public static final short sid = 20;
    private byte field_1_header_len;
    private byte field_2_reserved;
    private byte field_3_unicode_flag;
    private String field_4_header;

    public HeaderRecord() {
    }

    public HeaderRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 20) {
            throw new RecordFormatException("NOT A HEADERRECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        if (recordInputStream.remaining() > 0) {
            this.field_1_header_len = recordInputStream.readByte();
            this.field_2_reserved = recordInputStream.readByte();
            this.field_3_unicode_flag = recordInputStream.readByte();
            this.field_4_header = this.isMultibyte() ? recordInputStream.readUnicodeLEString(LittleEndian.ubyteToInt(this.field_1_header_len)) : recordInputStream.readCompressedUnicode(LittleEndian.ubyteToInt(this.field_1_header_len));
        }
    }

    public boolean isMultibyte() {
        return (this.field_3_unicode_flag & 0xFF) == 1;
    }

    public void setHeaderLength(byte by) {
        this.field_1_header_len = by;
    }

    public void setHeader(String string) {
        this.field_4_header = string;
        this.field_3_unicode_flag = (byte)(StringUtil.hasMultibyte(this.field_4_header) ? 1 : 0);
    }

    public short getHeaderLength() {
        return (short)(0xFF & this.field_1_header_len);
    }

    public String getHeader() {
        return this.field_4_header;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[HEADER]\n");
        stringBuffer.append("    .length         = ").append(this.getHeaderLength()).append("\n");
        stringBuffer.append("    .header         = ").append(this.getHeader()).append("\n");
        stringBuffer.append("[/HEADER]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = 4;
        if (this.getHeaderLength() != 0) {
            n2 += 3;
        }
        short s = (short)(this.isMultibyte() ? this.getHeaderLength() * 2 : this.getHeaderLength());
        LittleEndian.putShort(byArray, 0 + n, (short)20);
        LittleEndian.putShort(byArray, 2 + n, (short)(n2 - 4 + s));
        if (this.getHeaderLength() > 0) {
            byArray[4 + n] = (byte)this.getHeaderLength();
            byArray[6 + n] = this.field_3_unicode_flag;
            if (this.isMultibyte()) {
                StringUtil.putUnicodeLE(this.getHeader(), byArray, 7 + n);
            } else {
                StringUtil.putCompressedUnicode(this.getHeader(), byArray, 7 + n);
            }
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        int n = 4;
        if (this.getHeaderLength() != 0) {
            n += 3;
        }
        return this.isMultibyte() ? n + this.getHeaderLength() * 2 : n + this.getHeaderLength();
    }

    public short getSid() {
        return 20;
    }

    public Object clone() {
        HeaderRecord headerRecord = new HeaderRecord();
        headerRecord.field_1_header_len = this.field_1_header_len;
        headerRecord.field_2_reserved = this.field_2_reserved;
        headerRecord.field_3_unicode_flag = this.field_3_unicode_flag;
        headerRecord.field_4_header = this.field_4_header;
        return headerRecord;
    }
}

