/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.SubRecord;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class GroupMarkerSubRecord
extends SubRecord {
    public static final short sid = 6;
    private byte[] reserved = new byte[0];

    public GroupMarkerSubRecord() {
    }

    public GroupMarkerSubRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 6) {
            throw new RecordFormatException("Not a Group Marker record");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.reserved = recordInputStream.readRemainder();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("[ftGmo]" + string);
        stringBuffer.append("  reserved = ").append(HexDump.toHex(this.reserved)).append(string);
        stringBuffer.append("[/ftGmo]" + string);
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)6);
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        System.arraycopy(this.reserved, 0, byArray, n + 4, this.getRecordSize() - 4);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 4 + this.reserved.length;
    }

    public short getSid() {
        return 6;
    }

    public Object clone() {
        GroupMarkerSubRecord groupMarkerSubRecord = new GroupMarkerSubRecord();
        groupMarkerSubRecord.reserved = new byte[this.reserved.length];
        for (int i = 0; i < this.reserved.length; ++i) {
            groupMarkerSubRecord.reserved[i] = this.reserved[i];
        }
        return groupMarkerSubRecord;
    }
}

