/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class FrameRecord
extends Record {
    public static final short sid = 4146;
    private short field_1_borderType;
    public static final short BORDER_TYPE_REGULAR = 0;
    public static final short BORDER_TYPE_SHADOW = 1;
    private short field_2_options;
    private BitField autoSize = BitFieldFactory.getInstance(1);
    private BitField autoPosition = BitFieldFactory.getInstance(2);

    public FrameRecord() {
    }

    public FrameRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 4146) {
            throw new RecordFormatException("Not a Frame record");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_borderType = recordInputStream.readShort();
        this.field_2_options = recordInputStream.readShort();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[FRAME]\n");
        stringBuffer.append("    .borderType           = ").append("0x").append(HexDump.toHex(this.getBorderType())).append(" (").append(this.getBorderType()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .options              = ").append("0x").append(HexDump.toHex(this.getOptions())).append(" (").append(this.getOptions()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("         .autoSize                 = ").append(this.isAutoSize()).append('\n');
        stringBuffer.append("         .autoPosition             = ").append(this.isAutoPosition()).append('\n');
        stringBuffer.append("[/FRAME]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = 0;
        LittleEndian.putShort(byArray, 0 + n, (short)4146);
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(byArray, 4 + n + n2, this.field_1_borderType);
        LittleEndian.putShort(byArray, 6 + n + n2, this.field_2_options);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 8;
    }

    public short getSid() {
        return 4146;
    }

    public Object clone() {
        FrameRecord frameRecord = new FrameRecord();
        frameRecord.field_1_borderType = this.field_1_borderType;
        frameRecord.field_2_options = this.field_2_options;
        return frameRecord;
    }

    public short getBorderType() {
        return this.field_1_borderType;
    }

    public void setBorderType(short s) {
        this.field_1_borderType = s;
    }

    public short getOptions() {
        return this.field_2_options;
    }

    public void setOptions(short s) {
        this.field_2_options = s;
    }

    public void setAutoSize(boolean bl) {
        this.field_2_options = this.autoSize.setShortBoolean(this.field_2_options, bl);
    }

    public boolean isAutoSize() {
        return this.autoSize.isSet(this.field_2_options);
    }

    public void setAutoPosition(boolean bl) {
        this.field_2_options = this.autoPosition.setShortBoolean(this.field_2_options, bl);
    }

    public boolean isAutoPosition() {
        return this.autoPosition.isSet(this.field_2_options);
    }
}

