/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.CellValueRecordInterface;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.formula.Ptg;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;
import java.util.List;
import java.util.Stack;

public final class FormulaRecord
extends Record
implements CellValueRecordInterface,
Comparable {
    public static final short sid = 6;
    private int field_1_row;
    private short field_2_column;
    private short field_3_xf;
    private double field_4_value;
    private short field_5_options;
    private BitField alwaysCalc = BitFieldFactory.getInstance(1);
    private BitField calcOnLoad = BitFieldFactory.getInstance(2);
    private BitField sharedFormula = BitFieldFactory.getInstance(8);
    private int field_6_zero;
    private short field_7_expression_len;
    private Stack field_8_parsed_expr;
    private byte[] value_data;
    private byte[] all_data;

    public FormulaRecord() {
        this.field_8_parsed_expr = new Stack();
    }

    public FormulaRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        try {
            this.field_1_row = recordInputStream.readUShort();
            this.field_2_column = recordInputStream.readShort();
            this.field_3_xf = recordInputStream.readShort();
            this.field_4_value = recordInputStream.readDouble();
            this.field_5_options = recordInputStream.readShort();
            if (Double.isNaN(this.field_4_value)) {
                this.value_data = recordInputStream.getNANData();
            }
            this.field_6_zero = recordInputStream.readInt();
            this.field_7_expression_len = recordInputStream.readShort();
            try {
                this.field_8_parsed_expr = Ptg.createParsedExpressionTokens(this.field_7_expression_len, recordInputStream);
            }
            catch (RuntimeException runtimeException) {}
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new RecordFormatException(unsupportedOperationException);
        }
        if (recordInputStream.remaining() == 10) {
            // empty if block
        }
    }

    public void setRow(int n) {
        this.field_1_row = n;
    }

    public void setColumn(short s) {
        this.field_2_column = s;
    }

    public void setXFIndex(short s) {
        this.field_3_xf = s;
    }

    public void setValue(double d) {
        this.field_4_value = d;
    }

    public void setOptions(short s) {
        this.field_5_options = s;
    }

    public void setExpressionLength(short s) {
        this.field_7_expression_len = s;
    }

    public int getRow() {
        return this.field_1_row;
    }

    public short getColumn() {
        return this.field_2_column;
    }

    public short getXFIndex() {
        return this.field_3_xf;
    }

    public double getValue() {
        return this.field_4_value;
    }

    public short getOptions() {
        return this.field_5_options;
    }

    public boolean isSharedFormula() {
        return this.sharedFormula.isSet(this.field_5_options);
    }

    public void setSharedFormula(boolean bl) {
        this.field_5_options = this.sharedFormula.setShortBoolean(this.field_5_options, bl);
    }

    public boolean isAlwaysCalc() {
        return this.alwaysCalc.isSet(this.field_5_options);
    }

    public void setAlwaysCalc(boolean bl) {
        this.field_5_options = this.alwaysCalc.setShortBoolean(this.field_5_options, bl);
    }

    public boolean isCalcOnLoad() {
        return this.calcOnLoad.isSet(this.field_5_options);
    }

    public void setCalcOnLoad(boolean bl) {
        this.field_5_options = this.calcOnLoad.setShortBoolean(this.field_5_options, bl);
    }

    public short getExpressionLength() {
        return this.field_7_expression_len;
    }

    public void pushExpressionToken(Ptg ptg) {
        this.field_8_parsed_expr.push(ptg);
    }

    public Ptg popExpressionToken() {
        return (Ptg)this.field_8_parsed_expr.pop();
    }

    public Ptg peekExpressionToken() {
        return (Ptg)this.field_8_parsed_expr.peek();
    }

    public int getNumberOfExpressionTokens() {
        if (this.field_8_parsed_expr == null) {
            return 0;
        }
        return this.field_8_parsed_expr.size();
    }

    public List getParsedExpression() {
        return this.field_8_parsed_expr;
    }

    public void setParsedExpression(Stack stack) {
        this.field_8_parsed_expr = stack;
    }

    protected void validateSid(short s) {
        if (s != 6) {
            throw new RecordFormatException("NOT A FORMULA RECORD");
        }
    }

    public short getSid() {
        return 6;
    }

    public int serialize(int n, byte[] byArray) {
        if (this.field_8_parsed_expr != null) {
            int n2 = this.getTotalPtgSize();
            LittleEndian.putShort(byArray, 0 + n, (short)6);
            LittleEndian.putShort(byArray, 2 + n, (short)(22 + n2));
            LittleEndian.putShort(byArray, 4 + n, (short)this.getRow());
            LittleEndian.putShort(byArray, 6 + n, this.getColumn());
            LittleEndian.putShort(byArray, 8 + n, this.getXFIndex());
            if (Double.isNaN(this.getValue()) && this.value_data != null) {
                System.arraycopy(this.value_data, 0, byArray, 10 + n, this.value_data.length);
            } else {
                LittleEndian.putDouble(byArray, 10 + n, this.field_4_value);
            }
            LittleEndian.putShort(byArray, 18 + n, this.getOptions());
            LittleEndian.putInt(byArray, 20 + n, 0);
            LittleEndian.putShort(byArray, 24 + n, this.getExpressionLength());
            Ptg.serializePtgStack(this.field_8_parsed_expr, byArray, 26 + n);
        } else {
            System.arraycopy(this.all_data, 0, byArray, n, this.all_data.length);
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        int n = 0;
        n = this.field_8_parsed_expr != null ? this.getTotalPtgSize() + 26 : this.all_data.length;
        return n;
    }

    private int getTotalPtgSize() {
        List list = this.getParsedExpression();
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            Ptg ptg = (Ptg)list.get(i);
            n += ptg.getSize();
        }
        return n;
    }

    public boolean isBefore(CellValueRecordInterface cellValueRecordInterface) {
        if (this.getRow() > cellValueRecordInterface.getRow()) {
            return false;
        }
        if (this.getRow() == cellValueRecordInterface.getRow() && this.getColumn() > cellValueRecordInterface.getColumn()) {
            return false;
        }
        return this.getRow() != cellValueRecordInterface.getRow() || this.getColumn() != cellValueRecordInterface.getColumn();
    }

    public boolean isAfter(CellValueRecordInterface cellValueRecordInterface) {
        if (this.getRow() < cellValueRecordInterface.getRow()) {
            return false;
        }
        if (this.getRow() == cellValueRecordInterface.getRow() && this.getColumn() < cellValueRecordInterface.getColumn()) {
            return false;
        }
        return this.getRow() != cellValueRecordInterface.getRow() || this.getColumn() != cellValueRecordInterface.getColumn();
    }

    public boolean isEqual(CellValueRecordInterface cellValueRecordInterface) {
        return this.getRow() == cellValueRecordInterface.getRow() && this.getColumn() == cellValueRecordInterface.getColumn();
    }

    public boolean isInValueSection() {
        return true;
    }

    public boolean isValue() {
        return true;
    }

    public int compareTo(Object object) {
        CellValueRecordInterface cellValueRecordInterface = (CellValueRecordInterface)object;
        if (this.getRow() == cellValueRecordInterface.getRow() && this.getColumn() == cellValueRecordInterface.getColumn()) {
            return 0;
        }
        if (this.getRow() < cellValueRecordInterface.getRow()) {
            return -1;
        }
        if (this.getRow() > cellValueRecordInterface.getRow()) {
            return 1;
        }
        if (this.getColumn() < cellValueRecordInterface.getColumn()) {
            return -1;
        }
        if (this.getColumn() > cellValueRecordInterface.getColumn()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CellValueRecordInterface)) {
            return false;
        }
        CellValueRecordInterface cellValueRecordInterface = (CellValueRecordInterface)object;
        return this.getRow() == cellValueRecordInterface.getRow() && this.getColumn() == cellValueRecordInterface.getColumn();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[FORMULA]\n");
        stringBuffer.append("    .row       = ").append(Integer.toHexString(this.getRow())).append("\n");
        stringBuffer.append("    .column    = ").append(Integer.toHexString(this.getColumn())).append("\n");
        stringBuffer.append("    .xf              = ").append(Integer.toHexString(this.getXFIndex())).append("\n");
        if (Double.isNaN(this.getValue()) && this.value_data != null) {
            stringBuffer.append("    .value (NaN)     = ").append(HexDump.dump(this.value_data, 0L, 0)).append("\n");
        } else {
            stringBuffer.append("    .value           = ").append(this.getValue()).append("\n");
        }
        stringBuffer.append("    .options         = ").append(this.getOptions()).append("\n");
        stringBuffer.append("      .alwaysCalc         = ").append(this.alwaysCalc.isSet(this.getOptions())).append("\n");
        stringBuffer.append("      .calcOnLoad         = ").append(this.calcOnLoad.isSet(this.getOptions())).append("\n");
        stringBuffer.append("      .sharedFormula         = ").append(this.sharedFormula.isSet(this.getOptions())).append("\n");
        stringBuffer.append("    .zero            = ").append(this.field_6_zero).append("\n");
        stringBuffer.append("    .expressionlength= ").append(this.getExpressionLength()).append("\n");
        if (this.field_8_parsed_expr != null) {
            stringBuffer.append("    .numptgsinarray  = ").append(this.field_8_parsed_expr.size()).append("\n");
            for (int i = 0; i < this.field_8_parsed_expr.size(); ++i) {
                stringBuffer.append("     Ptg(").append(i).append(")=").append(this.field_8_parsed_expr.get(i).toString()).append("\n").append(((Ptg)this.field_8_parsed_expr.get(i)).toDebugString()).append("\n");
            }
        } else {
            stringBuffer.append("Formula full data \n").append(HexDump.dump(this.all_data, 0L, 0));
        }
        stringBuffer.append("[/FORMULA]\n");
        return stringBuffer.toString();
    }

    public Object clone() {
        FormulaRecord formulaRecord = new FormulaRecord();
        formulaRecord.field_1_row = this.field_1_row;
        formulaRecord.field_2_column = this.field_2_column;
        formulaRecord.field_3_xf = this.field_3_xf;
        formulaRecord.field_4_value = this.field_4_value;
        formulaRecord.field_5_options = this.field_5_options;
        formulaRecord.field_6_zero = this.field_6_zero;
        formulaRecord.field_7_expression_len = this.field_7_expression_len;
        formulaRecord.field_8_parsed_expr = new Stack();
        int n = 0;
        if (this.field_8_parsed_expr != null) {
            n = this.field_8_parsed_expr.size();
        }
        for (int i = 0; i < n; ++i) {
            Ptg ptg = ((Ptg)this.field_8_parsed_expr.get(i)).copy();
            formulaRecord.field_8_parsed_expr.add(i, ptg);
        }
        formulaRecord.value_data = this.value_data;
        formulaRecord.all_data = this.all_data;
        return formulaRecord;
    }
}

