/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;
import com.fr.third.org.apache.poi.util.StringUtil;

public class FormatRecord
extends Record {
    public static final short sid = 1054;
    private short field_1_index_code;
    private short field_3_unicode_len;
    private boolean field_3_unicode_flag;
    private String field_4_formatstring;

    public FormatRecord() {
    }

    public FormatRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 1054) {
            throw new RecordFormatException("NOT A FORMAT RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_index_code = recordInputStream.readShort();
        this.field_3_unicode_len = recordInputStream.readShort();
        this.field_3_unicode_flag = (recordInputStream.readByte() & 1) != 0;
        this.field_4_formatstring = this.field_3_unicode_flag ? recordInputStream.readUnicodeLEString(this.field_3_unicode_len) : recordInputStream.readCompressedUnicode(this.field_3_unicode_len);
    }

    public void setIndexCode(short s) {
        this.field_1_index_code = s;
    }

    public void setFormatStringLength(byte by) {
        this.field_3_unicode_len = by;
    }

    public void setUnicodeFlag(boolean bl) {
        this.field_3_unicode_flag = bl;
    }

    public void setFormatString(String string) {
        this.field_4_formatstring = string;
        this.setUnicodeFlag(StringUtil.hasMultibyte(string));
    }

    public short getIndexCode() {
        return this.field_1_index_code;
    }

    public boolean getUnicodeFlag() {
        return this.field_3_unicode_flag;
    }

    public String getFormatString() {
        return this.field_4_formatstring;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[FORMAT]\n");
        stringBuffer.append("    .indexcode       = ").append(Integer.toHexString(this.getIndexCode())).append("\n");
        stringBuffer.append("    .unicode length  = ").append(Integer.toHexString(this.field_3_unicode_len)).append("\n");
        stringBuffer.append("    .isUnicode       = ").append(this.field_3_unicode_flag).append("\n");
        stringBuffer.append("    .formatstring    = ").append(this.getFormatString()).append("\n");
        stringBuffer.append("[/FORMAT]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)1054);
        LittleEndian.putShort(byArray, 2 + n, (short)(5 + (this.field_3_unicode_flag ? 2 * this.field_3_unicode_len : this.field_3_unicode_len)));
        LittleEndian.putShort(byArray, 4 + n, this.getIndexCode());
        LittleEndian.putShort(byArray, 6 + n, this.field_3_unicode_len);
        byArray[8 + n] = (byte)(this.field_3_unicode_flag ? 1 : 0);
        if (this.field_3_unicode_flag) {
            StringUtil.putUnicodeLE(this.getFormatString(), byArray, 9 + n);
        } else {
            StringUtil.putCompressedUnicode(this.getFormatString(), byArray, 9 + n);
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 9 + (this.field_3_unicode_flag ? 2 * this.field_3_unicode_len : this.field_3_unicode_len);
    }

    public short getSid() {
        return 1054;
    }
}

