/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;
import com.fr.third.org.apache.poi.util.StringUtil;

public class FooterRecord
extends Record {
    public static final short sid = 21;
    private byte field_1_footer_len;
    private byte field_2_reserved;
    private byte field_3_unicode_flag;
    private String field_4_footer;

    public FooterRecord() {
    }

    public FooterRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 21) {
            throw new RecordFormatException("NOT A FooterRECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        if (recordInputStream.remaining() > 0) {
            this.field_1_footer_len = recordInputStream.readByte();
            this.field_2_reserved = recordInputStream.readByte();
            this.field_3_unicode_flag = recordInputStream.readByte();
            this.field_4_footer = this.isMultibyte() ? recordInputStream.readUnicodeLEString(LittleEndian.ubyteToInt(this.field_1_footer_len)) : recordInputStream.readCompressedUnicode(LittleEndian.ubyteToInt(this.field_1_footer_len));
        }
    }

    public boolean isMultibyte() {
        return (this.field_3_unicode_flag & 0xFF) == 1;
    }

    public void setFooterLength(byte by) {
        this.field_1_footer_len = by;
    }

    public void setFooter(String string) {
        this.field_4_footer = string;
        this.field_3_unicode_flag = (byte)(StringUtil.hasMultibyte(this.field_4_footer) ? 1 : 0);
    }

    public short getFooterLength() {
        return (short)(0xFF & this.field_1_footer_len);
    }

    public String getFooter() {
        return this.field_4_footer;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[FOOTER]\n");
        stringBuffer.append("    .footerlen      = ").append(Integer.toHexString(this.getFooterLength())).append("\n");
        stringBuffer.append("    .footer         = ").append(this.getFooter()).append("\n");
        stringBuffer.append("[/FOOTER]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = 4;
        if (this.getFooterLength() > 0) {
            n2 += 3;
        }
        short s = (short)(this.isMultibyte() ? this.getFooterLength() * 2 : this.getFooterLength());
        LittleEndian.putShort(byArray, 0 + n, (short)21);
        LittleEndian.putShort(byArray, 2 + n, (short)(n2 - 4 + s));
        if (this.getFooterLength() > 0) {
            byArray[4 + n] = (byte)this.getFooterLength();
            byArray[6 + n] = this.field_3_unicode_flag;
            if (this.isMultibyte()) {
                StringUtil.putUnicodeLE(this.getFooter(), byArray, 7 + n);
            } else {
                StringUtil.putCompressedUnicode(this.getFooter(), byArray, 7 + n);
            }
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        int n = 4;
        if (this.getFooterLength() > 0) {
            n += 3;
        }
        return this.isMultibyte() ? n + this.getFooterLength() * 2 : n + this.getFooterLength();
    }

    public short getSid() {
        return 21;
    }

    public Object clone() {
        FooterRecord footerRecord = new FooterRecord();
        footerRecord.field_1_footer_len = this.field_1_footer_len;
        footerRecord.field_2_reserved = this.field_2_reserved;
        footerRecord.field_3_unicode_flag = this.field_3_unicode_flag;
        footerRecord.field_4_footer = this.field_4_footer;
        return footerRecord;
    }
}

