/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.LittleEndian;
import com.fr.third.org.apache.poi.util.StringUtil;

public class FontRecord
extends Record {
    public static final short sid = 49;
    public static final short SS_NONE = 0;
    public static final short SS_SUPER = 1;
    public static final short SS_SUB = 2;
    public static final byte U_NONE = 0;
    public static final byte U_SINGLE = 1;
    public static final byte U_DOUBLE = 2;
    public static final byte U_SINGLE_ACCOUNTING = 33;
    public static final byte U_DOUBLE_ACCOUNTING = 34;
    private short field_1_font_height;
    private short field_2_attributes;
    private static final BitField italic = BitFieldFactory.getInstance(2);
    private static final BitField strikeout = BitFieldFactory.getInstance(8);
    private static final BitField macoutline = BitFieldFactory.getInstance(16);
    private static final BitField macshadow = BitFieldFactory.getInstance(32);
    private short field_3_color_palette_index;
    private short field_4_bold_weight;
    private short field_5_super_sub_script;
    private byte field_6_underline;
    private byte field_7_family;
    private byte field_8_charset;
    private byte field_9_zero = 0;
    private byte field_10_font_name_len;
    private String field_11_font_name;

    public FontRecord() {
    }

    public FontRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 49) {
            throw new RecordFormatException("NOT A FONT RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_font_height = recordInputStream.readShort();
        this.field_2_attributes = recordInputStream.readShort();
        this.field_3_color_palette_index = recordInputStream.readShort();
        this.field_4_bold_weight = recordInputStream.readShort();
        this.field_5_super_sub_script = recordInputStream.readShort();
        this.field_6_underline = recordInputStream.readByte();
        this.field_7_family = recordInputStream.readByte();
        this.field_8_charset = recordInputStream.readByte();
        this.field_9_zero = recordInputStream.readByte();
        this.field_10_font_name_len = recordInputStream.readByte();
        if (this.field_10_font_name_len > 0) {
            this.field_11_font_name = recordInputStream.readByte() == 0 ? recordInputStream.readCompressedUnicode(LittleEndian.ubyteToInt(this.field_10_font_name_len)) : recordInputStream.readUnicodeLEString(this.field_10_font_name_len);
        }
    }

    public void setFontHeight(short s) {
        this.field_1_font_height = s;
    }

    public void setAttributes(short s) {
        this.field_2_attributes = s;
    }

    public void setItalic(boolean bl) {
        this.field_2_attributes = italic.setShortBoolean(this.field_2_attributes, bl);
    }

    public void setStrikeout(boolean bl) {
        this.field_2_attributes = strikeout.setShortBoolean(this.field_2_attributes, bl);
    }

    public void setMacoutline(boolean bl) {
        this.field_2_attributes = macoutline.setShortBoolean(this.field_2_attributes, bl);
    }

    public void setMacshadow(boolean bl) {
        this.field_2_attributes = macshadow.setShortBoolean(this.field_2_attributes, bl);
    }

    public void setColorPaletteIndex(short s) {
        this.field_3_color_palette_index = s;
    }

    public void setBoldWeight(short s) {
        this.field_4_bold_weight = s;
    }

    public void setSuperSubScript(short s) {
        this.field_5_super_sub_script = s;
    }

    public void setUnderline(byte by) {
        this.field_6_underline = by;
    }

    public void setFamily(byte by) {
        this.field_7_family = by;
    }

    public void setCharset(byte by) {
        this.field_8_charset = by;
    }

    public void setFontNameLength(byte by) {
        this.field_10_font_name_len = by;
    }

    public void setFontName(String string) {
        this.field_11_font_name = string;
    }

    public short getFontHeight() {
        return this.field_1_font_height;
    }

    public short getAttributes() {
        return this.field_2_attributes;
    }

    public boolean isItalic() {
        return italic.isSet(this.field_2_attributes);
    }

    public boolean isStruckout() {
        return strikeout.isSet(this.field_2_attributes);
    }

    public boolean isMacoutlined() {
        return macoutline.isSet(this.field_2_attributes);
    }

    public boolean isMacshadowed() {
        return macshadow.isSet(this.field_2_attributes);
    }

    public short getColorPaletteIndex() {
        return this.field_3_color_palette_index;
    }

    public short getBoldWeight() {
        return this.field_4_bold_weight;
    }

    public short getSuperSubScript() {
        return this.field_5_super_sub_script;
    }

    public byte getUnderline() {
        return this.field_6_underline;
    }

    public byte getFamily() {
        return this.field_7_family;
    }

    public byte getCharset() {
        return this.field_8_charset;
    }

    public byte getFontNameLength() {
        return this.field_10_font_name_len;
    }

    public String getFontName() {
        return this.field_11_font_name;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[FONT]\n");
        stringBuffer.append("    .fontheight      = ").append(Integer.toHexString(this.getFontHeight())).append("\n");
        stringBuffer.append("    .attributes      = ").append(Integer.toHexString(this.getAttributes())).append("\n");
        stringBuffer.append("         .italic     = ").append(this.isItalic()).append("\n");
        stringBuffer.append("         .strikout   = ").append(this.isStruckout()).append("\n");
        stringBuffer.append("         .macoutlined= ").append(this.isMacoutlined()).append("\n");
        stringBuffer.append("         .macshadowed= ").append(this.isMacshadowed()).append("\n");
        stringBuffer.append("    .colorpalette    = ").append(Integer.toHexString(this.getColorPaletteIndex())).append("\n");
        stringBuffer.append("    .boldweight      = ").append(Integer.toHexString(this.getBoldWeight())).append("\n");
        stringBuffer.append("    .supersubscript  = ").append(Integer.toHexString(this.getSuperSubScript())).append("\n");
        stringBuffer.append("    .underline       = ").append(Integer.toHexString(this.getUnderline())).append("\n");
        stringBuffer.append("    .family          = ").append(Integer.toHexString(this.getFamily())).append("\n");
        stringBuffer.append("    .charset         = ").append(Integer.toHexString(this.getCharset())).append("\n");
        stringBuffer.append("    .namelength      = ").append(Integer.toHexString(this.getFontNameLength())).append("\n");
        stringBuffer.append("    .fontname        = ").append(this.getFontName()).append("\n");
        stringBuffer.append("[/FONT]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = this.getFontNameLength() * 2;
        LittleEndian.putShort(byArray, 0 + n, (short)49);
        LittleEndian.putShort(byArray, 2 + n, (short)(15 + n2 + 1));
        LittleEndian.putShort(byArray, 4 + n, this.getFontHeight());
        LittleEndian.putShort(byArray, 6 + n, this.getAttributes());
        LittleEndian.putShort(byArray, 8 + n, this.getColorPaletteIndex());
        LittleEndian.putShort(byArray, 10 + n, this.getBoldWeight());
        LittleEndian.putShort(byArray, 12 + n, this.getSuperSubScript());
        byArray[14 + n] = this.getUnderline();
        byArray[15 + n] = this.getFamily();
        byArray[16 + n] = this.getCharset();
        byArray[17 + n] = this.field_9_zero;
        byArray[18 + n] = this.getFontNameLength();
        byArray[19 + n] = 1;
        if (this.getFontName() != null) {
            StringUtil.putUnicodeLE(this.getFontName(), byArray, 20 + n);
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return this.getFontNameLength() * 2 + 20;
    }

    public short getSid() {
        return 49;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.field_11_font_name == null ? 0 : this.field_11_font_name.hashCode());
        n = 31 * n + this.field_1_font_height;
        n = 31 * n + this.field_2_attributes;
        n = 31 * n + this.field_3_color_palette_index;
        n = 31 * n + this.field_4_bold_weight;
        n = 31 * n + this.field_5_super_sub_script;
        n = 31 * n + this.field_6_underline;
        n = 31 * n + this.field_7_family;
        n = 31 * n + this.field_8_charset;
        n = 31 * n + this.field_9_zero;
        n = 31 * n + this.field_10_font_name_len;
        return n;
    }

    public boolean equals(Object object) {
        return this == object;
    }
}

