/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;
import com.fr.third.org.apache.poi.util.StringUtil;

public final class FileSharingRecord
extends Record {
    public static final short sid = 91;
    private short field_1_readonly;
    private short field_2_password;
    private byte field_3_username_unicode_options;
    private String field_3_username_value;

    public FileSharingRecord() {
    }

    public FileSharingRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 91) {
            throw new RecordFormatException("NOT A FILESHARING RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_readonly = recordInputStream.readShort();
        this.field_2_password = recordInputStream.readShort();
        short s = recordInputStream.readShort();
        if (s > 0) {
            this.field_3_username_unicode_options = recordInputStream.readByte();
            this.field_3_username_value = recordInputStream.readCompressedUnicode(s);
        } else {
            this.field_3_username_value = "";
        }
    }

    public static short hashPassword(String string) {
        byte[] byArray = string.getBytes();
        int n = 0;
        if (byArray.length > 0) {
            int n2 = byArray.length;
            while (n2-- > 0) {
                n = n >> 14 & 1 | n << 1 & Short.MAX_VALUE;
                n ^= byArray[n2];
            }
            n = n >> 14 & 1 | n << 1 & Short.MAX_VALUE;
            n ^= byArray.length;
            n ^= 0xCE4B;
        }
        return (short)n;
    }

    public void setReadOnly(short s) {
        this.field_1_readonly = s;
    }

    public short getReadOnly() {
        return this.field_1_readonly;
    }

    public void setPassword(short s) {
        this.field_2_password = s;
    }

    public short getPassword() {
        return this.field_2_password;
    }

    public short getUsernameLength() {
        return (short)this.field_3_username_value.length();
    }

    public String getUsername() {
        return this.field_3_username_value;
    }

    public void setUsername(String string) {
        this.field_3_username_value = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[FILESHARING]\n");
        stringBuffer.append("    .readonly       = ").append(this.getReadOnly() == 1 ? "true" : "false").append("\n");
        stringBuffer.append("    .password       = ").append(Integer.toHexString(this.getPassword())).append("\n");
        stringBuffer.append("    .username       = ").append(this.getUsername()).append("\n");
        stringBuffer.append("[/FILESHARING]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)91);
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(byArray, 4 + n, this.getReadOnly());
        LittleEndian.putShort(byArray, 6 + n, this.getPassword());
        LittleEndian.putShort(byArray, 8 + n, this.getUsernameLength());
        if (this.getUsernameLength() > 0) {
            LittleEndian.putByte(byArray, 10 + n, this.field_3_username_unicode_options);
            StringUtil.putCompressedUnicode(this.getUsername(), byArray, 11 + n);
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        short s = this.getUsernameLength();
        if (s < 1) {
            return 10;
        }
        return 11 + s;
    }

    public short getSid() {
        return 91;
    }

    public Object clone() {
        FileSharingRecord fileSharingRecord = new FileSharingRecord();
        fileSharingRecord.setReadOnly(this.field_1_readonly);
        fileSharingRecord.setPassword(this.field_2_password);
        fileSharingRecord.setUsername(this.field_3_username_value);
        return fileSharingRecord;
    }
}

