/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.util.PWDUtils;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class FilePassRecord
extends Record {
    public static final short sid = 47;
    private short field_1_key;
    private short field_2_hash;
    private String pwdString = null;

    public FilePassRecord() {
    }

    public FilePassRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 47) {
            throw new RecordFormatException("NOT A FILEPASS RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        recordInputStream.readShort();
        this.field_1_key = recordInputStream.readShort();
        this.field_2_hash = recordInputStream.readShort();
    }

    public short getKey() {
        return this.field_1_key;
    }

    public void setKey(short s) {
        this.field_1_key = s;
    }

    public short getHash() {
        return this.field_2_hash;
    }

    public void setHash(short s) {
        this.field_2_hash = s;
    }

    public void setPassword(String string) {
        this.pwdString = string;
        byte[] byArray = string.getBytes();
        this.setKey(PWDUtils.getEncryptionKey(byArray));
        this.setHash(PWDUtils.getPasswordHash(byArray));
    }

    public String getPassword() {
        return this.pwdString;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[FILEPASS]\n");
        stringBuffer.append("    .key            = ").append(Integer.toHexString(this.getKey())).append("\n");
        stringBuffer.append("    .hash           = ").append(Integer.toHexString(this.getHash())).append("\n");
        stringBuffer.append("[/FILEPASS]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)47);
        LittleEndian.putShort(byArray, 2 + n, (short)6);
        LittleEndian.putShort(byArray, 4 + n, (short)0);
        LittleEndian.putShort(byArray, 6 + n, this.getKey());
        LittleEndian.putShort(byArray, 8 + n, this.getHash());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 10;
    }

    public short getSid() {
        return 47;
    }

    public Object clone() {
        return super.clone();
    }
}

