/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.formula.Ptg;
import com.fr.third.org.apache.poi.util.LittleEndian;
import com.fr.third.org.apache.poi.util.StringUtil;
import java.util.Stack;

public final class ExternalNameRecord
extends Record {
    private static final Ptg[] EMPTY_PTG_ARRAY = new Ptg[0];
    public static final short sid = 35;
    private static final int OPT_BUILTIN_NAME = 1;
    private static final int OPT_AUTOMATIC_LINK = 2;
    private static final int OPT_PICTURE_LINK = 4;
    private static final int OPT_STD_DOCUMENT_NAME = 8;
    private static final int OPT_OLE_LINK = 16;
    private static final int OPT_ICONIFIED_PICTURE_LINK = 32768;
    private short field_1_option_flag;
    private short field_2_index;
    private short field_3_not_used;
    private String field_4_name;
    private Ptg[] field_5_name_definition;

    public ExternalNameRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    public boolean isBuiltInName() {
        return (this.field_1_option_flag & 1) != 0;
    }

    public boolean isAutomaticLink() {
        return (this.field_1_option_flag & 2) != 0;
    }

    public boolean isPicureLink() {
        return (this.field_1_option_flag & 4) != 0;
    }

    public boolean isStdDocumentNameIdentifier() {
        return (this.field_1_option_flag & 8) != 0;
    }

    public boolean isOLELink() {
        return (this.field_1_option_flag & 0x10) != 0;
    }

    public boolean isIconifiedPictureLink() {
        return (this.field_1_option_flag & 0x8000) != 0;
    }

    public String getText() {
        return this.field_4_name;
    }

    protected void validateSid(short s) {
        if (s != 35) {
            throw new RecordFormatException("NOT A valid ExternalName RECORD");
        }
    }

    private int getDataSize() {
        int n = 8 + this.field_4_name.length();
        if (this.hasFormula()) {
            n += 2 + this.getNameDefinitionSize();
        }
        return n;
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = this.getDataSize();
        LittleEndian.putShort(byArray, 0 + n, (short)35);
        LittleEndian.putShort(byArray, 2 + n, (short)n2);
        LittleEndian.putShort(byArray, 4 + n, this.field_1_option_flag);
        LittleEndian.putShort(byArray, 6 + n, this.field_2_index);
        LittleEndian.putShort(byArray, 8 + n, this.field_3_not_used);
        short s = (short)this.field_4_name.length();
        LittleEndian.putShort(byArray, 10 + n, s);
        StringUtil.putCompressedUnicode(this.field_4_name, byArray, 12 + n);
        if (this.hasFormula()) {
            short s2 = (short)this.getNameDefinitionSize();
            LittleEndian.putShort(byArray, 12 + s + n, s2);
            Ptg.serializePtgStack(ExternalNameRecord.toStack(this.field_5_name_definition), byArray, 14 + s + n);
        }
        return n2 + 4;
    }

    private int getNameDefinitionSize() {
        int n = 0;
        for (int i = 0; i < this.field_5_name_definition.length; ++i) {
            n += this.field_5_name_definition[i].getSize();
        }
        return n;
    }

    public int getRecordSize() {
        return 4 + this.getDataSize();
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_option_flag = recordInputStream.readShort();
        this.field_2_index = recordInputStream.readShort();
        this.field_3_not_used = recordInputStream.readShort();
        short s = recordInputStream.readShort();
        this.field_4_name = recordInputStream.readCompressedUnicode(s);
        if (!this.hasFormula()) {
            if (recordInputStream.remaining() > 0) {
                throw this.readFail("Some unread data (is formula present?)");
            }
            this.field_5_name_definition = EMPTY_PTG_ARRAY;
            return;
        }
        if (recordInputStream.remaining() <= 0) {
            throw this.readFail("Ran out of record data trying to read formula.");
        }
        short s2 = recordInputStream.readShort();
        this.field_5_name_definition = ExternalNameRecord.toPtgArray(Ptg.createParsedExpressionTokens(s2, recordInputStream));
    }

    private RuntimeException readFail(String string) {
        String string2 = string + " fields: (option=" + this.field_1_option_flag + " index=" + this.field_2_index + " not_used=" + this.field_3_not_used + " name='" + this.field_4_name + "')";
        return new RuntimeException(string2);
    }

    private boolean hasFormula() {
        return !this.isAutomaticLink();
    }

    private static Ptg[] toPtgArray(Stack stack) {
        Ptg[] ptgArray = new Ptg[stack.size()];
        stack.toArray(ptgArray);
        return ptgArray;
    }

    private static Stack toStack(Ptg[] ptgArray) {
        Stack<Ptg> stack = new Stack<Ptg>();
        for (int i = 0; i < ptgArray.length; ++i) {
            stack.push(ptgArray[i]);
        }
        return stack;
    }

    public short getSid() {
        return 35;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName()).append(" [EXTERNALNAME ");
        stringBuffer.append(" ").append(this.field_4_name);
        stringBuffer.append(" ix=").append(this.field_2_index);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

