/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class ExternSheetSubRecord
extends Record {
    public static final short sid = 4095;
    private short field_1_index_to_supbook;
    private short field_2_index_to_first_supbook_sheet;
    private short field_3_index_to_last_supbook_sheet;

    public ExternSheetSubRecord() {
    }

    public ExternSheetSubRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    public void setIndexToSupBook(short s) {
        this.field_1_index_to_supbook = s;
    }

    public short getIndexToSupBook() {
        return this.field_1_index_to_supbook;
    }

    public void setIndexToFirstSupBook(short s) {
        this.field_2_index_to_first_supbook_sheet = s;
    }

    public short getIndexToFirstSupBook() {
        return this.field_2_index_to_first_supbook_sheet;
    }

    public void setIndexToLastSupBook(short s) {
        this.field_3_index_to_last_supbook_sheet = s;
    }

    public short getIndexToLastSupBook() {
        return this.field_3_index_to_last_supbook_sheet;
    }

    protected void validateSid(short s) {
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_index_to_supbook = recordInputStream.readShort();
        this.field_2_index_to_first_supbook_sheet = recordInputStream.readShort();
        this.field_3_index_to_last_supbook_sheet = recordInputStream.readShort();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("   supbookindex =").append(this.getIndexToSupBook()).append('\n');
        stringBuffer.append("   1stsbindex   =").append(this.getIndexToFirstSupBook()).append('\n');
        stringBuffer.append("   lastsbindex  =").append(this.getIndexToLastSupBook()).append('\n');
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, this.getIndexToSupBook());
        LittleEndian.putShort(byArray, 2 + n, this.getIndexToFirstSupBook());
        LittleEndian.putShort(byArray, 4 + n, this.getIndexToLastSupBook());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 4095;
    }
}

