/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.ExternSheetSubRecord;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;
import java.util.ArrayList;

public class ExternSheetRecord
extends Record {
    public static final short sid = 23;
    private short field_1_number_of_REF_sturcutres;
    private ArrayList field_2_REF_structures;

    public ExternSheetRecord() {
        this.field_2_REF_structures = new ArrayList();
    }

    public ExternSheetRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 23) {
            throw new RecordFormatException("NOT An ExternSheet RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_2_REF_structures = new ArrayList();
        this.field_1_number_of_REF_sturcutres = recordInputStream.readShort();
        for (int i = 0; i < this.field_1_number_of_REF_sturcutres; ++i) {
            ExternSheetSubRecord externSheetSubRecord = new ExternSheetSubRecord(recordInputStream);
            this.field_2_REF_structures.add(externSheetSubRecord);
        }
    }

    public void setNumOfREFStructures(short s) {
        this.field_1_number_of_REF_sturcutres = s;
    }

    public short getNumOfREFStructures() {
        return this.field_1_number_of_REF_sturcutres;
    }

    public void addREFRecord(ExternSheetSubRecord externSheetSubRecord) {
        this.field_2_REF_structures.add(externSheetSubRecord);
    }

    public int getNumOfREFRecords() {
        return this.field_2_REF_structures.size();
    }

    public ExternSheetSubRecord getREFRecordAt(int n) {
        ExternSheetSubRecord externSheetSubRecord = (ExternSheetSubRecord)this.field_2_REF_structures.get(n);
        return externSheetSubRecord;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[EXTERNSHEET]\n");
        stringBuffer.append("   numOfRefs     = ").append(this.getNumOfREFStructures()).append("\n");
        for (int i = 0; i < this.getNumOfREFRecords(); ++i) {
            stringBuffer.append("refrec         #").append(i).append('\n');
            stringBuffer.append(this.getREFRecordAt(i).toString());
            stringBuffer.append("----refrec     #").append(i).append('\n');
        }
        stringBuffer.append("[/EXTERNSHEET]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)23);
        LittleEndian.putShort(byArray, 2 + n, (short)(2 + this.getNumOfREFRecords() * 6));
        LittleEndian.putShort(byArray, 4 + n, this.getNumOfREFStructures());
        int n2 = 6;
        for (int i = 0; i < this.getNumOfREFRecords(); ++i) {
            ExternSheetSubRecord externSheetSubRecord = this.getREFRecordAt(i);
            System.arraycopy(externSheetSubRecord.serialize(), 0, byArray, n2 + n, 6);
            n2 += 6;
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6 + this.getNumOfREFRecords() * 6;
    }

    public short getSid() {
        return 23;
    }
}

