/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.ExtSSTInfoSubRecord;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;
import java.util.ArrayList;

public class ExtSSTRecord
extends Record {
    public static final int DEFAULT_BUCKET_SIZE = 8;
    public static final int MAX_BUCKETS = 128;
    public static final short sid = 255;
    private short field_1_strings_per_bucket = (short)8;
    private ArrayList field_2_sst_info;

    public ExtSSTRecord() {
        this.field_2_sst_info = new ArrayList();
    }

    public ExtSSTRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 255) {
            throw new RecordFormatException("NOT An EXTSST RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_2_sst_info = new ArrayList();
        this.field_1_strings_per_bucket = recordInputStream.readShort();
        while (recordInputStream.remaining() > 0) {
            ExtSSTInfoSubRecord extSSTInfoSubRecord = new ExtSSTInfoSubRecord(recordInputStream);
            this.field_2_sst_info.add(extSSTInfoSubRecord);
        }
    }

    public void setNumStringsPerBucket(short s) {
        this.field_1_strings_per_bucket = s;
    }

    public void addInfoRecord(ExtSSTInfoSubRecord extSSTInfoSubRecord) {
        this.field_2_sst_info.add(extSSTInfoSubRecord);
    }

    public short getNumStringsPerBucket() {
        return this.field_1_strings_per_bucket;
    }

    public int getNumInfoRecords() {
        return this.field_2_sst_info.size();
    }

    public ExtSSTInfoSubRecord getInfoRecordAt(int n) {
        return (ExtSSTInfoSubRecord)this.field_2_sst_info.get(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[EXTSST]\n");
        stringBuffer.append("    .dsst           = ").append(Integer.toHexString(this.getNumStringsPerBucket())).append("\n");
        stringBuffer.append("    .numInfoRecords = ").append(this.getNumInfoRecords()).append("\n");
        for (int i = 0; i < this.getNumInfoRecords(); ++i) {
            stringBuffer.append("    .inforecord     = ").append(i).append("\n");
            stringBuffer.append("    .streampos      = ").append(Integer.toHexString(this.getInfoRecordAt(i).getStreamPos())).append("\n");
            stringBuffer.append("    .sstoffset      = ").append(Integer.toHexString(this.getInfoRecordAt(i).getBucketSSTOffset())).append("\n");
        }
        stringBuffer.append("[/EXTSST]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)255);
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(byArray, 4 + n, this.field_1_strings_per_bucket);
        int n2 = 6;
        for (int i = 0; i < this.getNumInfoRecords(); ++i) {
            ExtSSTInfoSubRecord extSSTInfoSubRecord = this.getInfoRecordAt(i);
            n2 += extSSTInfoSubRecord.serialize(n2 + n, byArray);
        }
        return n2;
    }

    public int getRecordSize() {
        return 6 + 8 * this.getNumInfoRecords();
    }

    public static final int getNumberOfInfoRecsForStrings(int n) {
        int n2 = n / 8;
        if (n % 8 != 0) {
            ++n2;
        }
        if (n2 > 128) {
            n2 = 128;
        }
        return n2;
    }

    public static final int getRecordSizeForStrings(int n) {
        return 6 + ExtSSTRecord.getNumberOfInfoRecsForStrings(n) * 8;
    }

    public short getSid() {
        return 255;
    }

    public void setBucketOffsets(int[] nArray, int[] nArray2) {
        this.field_2_sst_info = new ArrayList(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            ExtSSTInfoSubRecord extSSTInfoSubRecord = new ExtSSTInfoSubRecord();
            extSSTInfoSubRecord.setBucketRecordOffset((short)nArray2[i]);
            extSSTInfoSubRecord.setStreamPos(nArray[i]);
            this.field_2_sst_info.add(extSSTInfoSubRecord);
        }
    }
}

