/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class ExtSSTInfoSubRecord
extends Record {
    public static final int INFO_SIZE = 8;
    public static final short sid = 4095;
    private int field_1_stream_pos;
    private short field_2_bucket_sst_offset;
    private short field_3_zero;

    public ExtSSTInfoSubRecord() {
    }

    public ExtSSTInfoSubRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_stream_pos = recordInputStream.readInt();
        this.field_2_bucket_sst_offset = recordInputStream.readShort();
        this.field_3_zero = recordInputStream.readShort();
    }

    public void setStreamPos(int n) {
        this.field_1_stream_pos = n;
    }

    public void setBucketRecordOffset(short s) {
        this.field_2_bucket_sst_offset = s;
    }

    public int getStreamPos() {
        return this.field_1_stream_pos;
    }

    public short getBucketSSTOffset() {
        return this.field_2_bucket_sst_offset;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[EXTSST]\n");
        stringBuffer.append("    .streampos      = ").append(Integer.toHexString(this.getStreamPos())).append("\n");
        stringBuffer.append("    .bucketsstoffset= ").append(Integer.toHexString(this.getBucketSSTOffset())).append("\n");
        stringBuffer.append("    .zero           = ").append(Integer.toHexString(this.field_3_zero)).append("\n");
        stringBuffer.append("[/EXTSST]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putInt(byArray, 0 + n, this.getStreamPos());
        LittleEndian.putShort(byArray, 4 + n, this.getBucketSSTOffset());
        LittleEndian.putShort(byArray, 6 + n, (short)0);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 8;
    }

    public short getSid() {
        return 4095;
    }
}

