/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class EndRecord
extends Record {
    public static final short sid = 4148;

    public EndRecord() {
    }

    public EndRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 4148) {
            throw new RecordFormatException("NOT An END RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[END]\n");
        stringBuffer.append("[/END]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)4148);
        LittleEndian.putShort(byArray, 2 + n, (short)0);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 4;
    }

    public short getSid() {
        return 4148;
    }
}

