/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.SubRecord;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;
import com.fr.third.org.apache.poi.util.StringUtil;

public class EmbeddedObjectRefSubRecord
extends SubRecord {
    public static final short sid = 9;
    public short field_1_stream_id_offset;
    public short[] field_2_unknown;
    public short field_3_unicode_len;
    public boolean field_4_unicode_flag;
    public String field_5_ole_classname;
    public int field_6_stream_id;
    private int field_5_ole_classname_padding;
    public byte[] remainingBytes;

    public EmbeddedObjectRefSubRecord() {
        this.field_2_unknown = new short[0];
        this.remainingBytes = new byte[0];
        this.field_1_stream_id_offset = (short)6;
        this.field_5_ole_classname = "";
    }

    public EmbeddedObjectRefSubRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 9) {
            throw new RecordFormatException("Not a EmbeddedObjectRef record");
        }
    }

    public short getSid() {
        return 9;
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_stream_id_offset = recordInputStream.readShort();
        this.field_2_unknown = recordInputStream.readShortArray();
        this.field_3_unicode_len = recordInputStream.readShort();
        this.field_4_unicode_flag = (recordInputStream.readByte() & 1) != 0;
        this.field_5_ole_classname = this.field_4_unicode_flag ? recordInputStream.readUnicodeLEString(this.field_3_unicode_len) : recordInputStream.readCompressedUnicode(this.field_3_unicode_len);
        this.field_5_ole_classname_padding = 0;
        while (recordInputStream.getRecordOffset() - 2 < this.field_1_stream_id_offset) {
            ++this.field_5_ole_classname_padding;
            recordInputStream.readByte();
        }
        this.field_6_stream_id = recordInputStream.readInt();
        this.remainingBytes = recordInputStream.readRemainder();
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = n;
        LittleEndian.putShort(byArray, n2, (short)9);
        LittleEndian.putShort(byArray, n2 += 2, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(byArray, n2 += 2, this.field_1_stream_id_offset);
        LittleEndian.putShortArray(byArray, n2 += 2, this.field_2_unknown);
        LittleEndian.putShort(byArray, n2 += this.field_2_unknown.length * 2 + 2, this.field_3_unicode_len);
        byArray[n2 += 2] = this.field_4_unicode_flag ? (byte)1 : 0;
        ++n2;
        if (this.field_4_unicode_flag) {
            StringUtil.putUnicodeLE(this.field_5_ole_classname, byArray, n2);
            n2 += this.field_5_ole_classname.length() * 2;
        } else {
            StringUtil.putCompressedUnicode(this.field_5_ole_classname, byArray, n2);
            n2 += this.field_5_ole_classname.length();
        }
        LittleEndian.putInt(byArray, n2 += this.field_5_ole_classname_padding, this.field_6_stream_id);
        System.arraycopy(this.remainingBytes, 0, byArray, n2 += 4, this.remainingBytes.length);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return this.remainingBytes.length + this.field_1_stream_id_offset + 2 + 4 + 4;
    }

    public int getStreamId() {
        return this.field_6_stream_id;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ftPictFmla]\n");
        stringBuffer.append("    .streamIdOffset       = ").append("0x").append(HexDump.toHex(this.field_1_stream_id_offset)).append(" (").append(this.field_1_stream_id_offset).append(" )").append(System.getProperty("line.separator"));
        stringBuffer.append("    .unknown              = ").append("0x").append(HexDump.toHex(this.field_2_unknown)).append(" (").append(this.field_2_unknown.length).append(" )").append(System.getProperty("line.separator"));
        stringBuffer.append("    .unicodeLen           = ").append("0x").append(HexDump.toHex(this.field_3_unicode_len)).append(" (").append(this.field_3_unicode_len).append(" )").append(System.getProperty("line.separator"));
        stringBuffer.append("    .unicodeFlag          = ").append("0x").append(this.field_4_unicode_flag ? 1 : 0).append(" (").append(this.field_4_unicode_flag).append(" )").append(System.getProperty("line.separator"));
        stringBuffer.append("    .oleClassname         = ").append(this.field_5_ole_classname).append(System.getProperty("line.separator"));
        stringBuffer.append("    .streamId             = ").append("0x").append(HexDump.toHex(this.field_6_stream_id)).append(" (").append(this.field_6_stream_id).append(" )").append(System.getProperty("line.separator"));
        stringBuffer.append("[/ftPictFmla]");
        return stringBuffer.toString();
    }
}

