/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class EOFRecord
extends Record {
    public static final short sid = 10;

    public EOFRecord() {
    }

    public EOFRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 10) {
            throw new RecordFormatException("NOT An EOF RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[EOF]\n");
        stringBuffer.append("[/EOF]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)10);
        LittleEndian.putShort(byArray, 2 + n, (short)0);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 4;
    }

    public short getSid() {
        return 10;
    }

    public Object clone() {
        EOFRecord eOFRecord = new EOFRecord();
        return eOFRecord;
    }
}

