/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class DrawingRecord
extends Record {
    public static final short sid = 236;
    private byte[] recordData;
    private byte[] contd;

    public DrawingRecord() {
    }

    public DrawingRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 236) {
            throw new RecordFormatException("Not a MSODRAWING record");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.recordData = recordInputStream.readRemainder();
    }

    public void processContinueRecord(byte[] byArray) {
        this.contd = byArray;
    }

    public int serialize(int n, byte[] byArray) {
        if (this.recordData == null) {
            this.recordData = new byte[0];
        }
        LittleEndian.putShort(byArray, 0 + n, (short)236);
        LittleEndian.putShort(byArray, 2 + n, (short)this.recordData.length);
        if (this.recordData.length > 0) {
            System.arraycopy(this.recordData, 0, byArray, 4 + n, this.recordData.length);
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        int n = 4;
        if (this.recordData != null) {
            n += this.recordData.length;
        }
        return n;
    }

    public short getSid() {
        return 236;
    }

    public byte[] getData() {
        if (this.contd != null) {
            byte[] byArray = new byte[this.recordData.length + this.contd.length];
            System.arraycopy(this.recordData, 0, byArray, 0, this.recordData.length);
            System.arraycopy(this.contd, 0, byArray, this.recordData.length, this.contd.length);
            return byArray;
        }
        return this.recordData;
    }

    public void setData(byte[] byArray) {
        this.recordData = byArray;
    }

    public Object clone() {
        DrawingRecord drawingRecord = new DrawingRecord();
        if (this.recordData != null) {
            drawingRecord.recordData = new byte[this.recordData.length];
            System.arraycopy(this.recordData, 0, drawingRecord.recordData, 0, this.recordData.length);
        }
        if (this.contd != null) {
            System.arraycopy(this.contd, 0, drawingRecord.contd, 0, this.contd.length);
            drawingRecord.contd = new byte[this.contd.length];
        }
        return drawingRecord;
    }
}

