/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.ddf.EscherRecord;
import com.fr.third.org.apache.poi.ddf.NullEscherSerializationListener;
import com.fr.third.org.apache.poi.hssf.record.AbstractEscherHolderRecord;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.ArrayUtil;
import com.fr.third.org.apache.poi.util.LittleEndian;
import java.util.Iterator;
import java.util.List;

public class DrawingGroupRecord
extends AbstractEscherHolderRecord {
    public static final short sid = 235;
    static final int MAX_RECORD_SIZE = 8228;
    private static final int MAX_DATA_SIZE = 8224;

    public DrawingGroupRecord() {
    }

    public DrawingGroupRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected String getRecordName() {
        return "MSODRAWINGGROUP";
    }

    public short getSid() {
        return 235;
    }

    public int serialize(int n, byte[] byArray) {
        byte[] byArray2 = this.getRawData();
        if (this.getEscherRecords().size() == 0 && byArray2 != null) {
            return this.writeData(n, byArray, byArray2);
        }
        byte[] byArray3 = new byte[this.getRawDataSize()];
        int n2 = 0;
        Iterator iterator = this.getEscherRecords().iterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = (EscherRecord)iterator.next();
            n2 += escherRecord.serialize(n2, byArray3, new NullEscherSerializationListener());
        }
        return this.writeData(n, byArray, byArray3);
    }

    public void processChildRecords() {
        this.convertRawBytesToEscherRecords();
    }

    public int getRecordSize() {
        return DrawingGroupRecord.grossSizeFromDataSize(this.getRawDataSize());
    }

    public int getRawDataSize() {
        List list = this.getEscherRecords();
        byte[] byArray = this.getRawData();
        if (list.size() == 0 && byArray != null) {
            return byArray.length;
        }
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = (EscherRecord)iterator.next();
            n += escherRecord.getRecordSize();
        }
        return n;
    }

    static int grossSizeFromDataSize(int n) {
        return n + ((n - 1) / 8224 + 1) * 4;
    }

    private int writeData(int n, byte[] byArray, byte[] byArray2) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray2.length) {
            int n4 = Math.min(byArray2.length - n3, 8224);
            if (n3 / 8224 >= 2) {
                this.writeContinueHeader(byArray, n, n4);
            } else {
                this.writeHeader(byArray, n, n4);
            }
            n2 += 4;
            ArrayUtil.arraycopy(byArray2, n3, byArray, n += 4, n4);
            n += n4;
            n3 += n4;
            n2 += n4;
        }
        return n2;
    }

    private void writeHeader(byte[] byArray, int n, int n2) {
        LittleEndian.putShort(byArray, 0 + n, this.getSid());
        LittleEndian.putShort(byArray, 2 + n, (short)n2);
    }

    private void writeContinueHeader(byte[] byArray, int n, int n2) {
        LittleEndian.putShort(byArray, 0 + n, (short)60);
        LittleEndian.putShort(byArray, 2 + n, (short)n2);
    }
}

