/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class DeltaRecord
extends Record {
    public static final short sid = 16;
    public static final double DEFAULT_VALUE = 0.001;
    private double field_1_max_change;

    public DeltaRecord() {
    }

    public DeltaRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 16) {
            throw new RecordFormatException("NOT A DELTA RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_max_change = recordInputStream.readDouble();
    }

    public void setMaxChange(double d) {
        this.field_1_max_change = d;
    }

    public double getMaxChange() {
        return this.field_1_max_change;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[DELTA]\n");
        stringBuffer.append("    .maxchange      = ").append(this.getMaxChange()).append("\n");
        stringBuffer.append("[/DELTA]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)16);
        LittleEndian.putShort(byArray, 2 + n, (short)8);
        LittleEndian.putDouble(byArray, 4 + n, this.getMaxChange());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 12;
    }

    public short getSid() {
        return 16;
    }

    public Object clone() {
        DeltaRecord deltaRecord = new DeltaRecord();
        deltaRecord.field_1_max_change = this.field_1_max_change;
        return deltaRecord;
    }
}

